package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAddressPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAddressService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAddressVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbAddressConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbAddressDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author carl.wang
 * @Description 地址管理
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdAbAddressServiceImpl implements PrdAbAddressService {
    private final CacheUtil cacheUtil;
    private final PrdAbAddressDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;

    @Value("${tw4.address.operation}")
    private String address_operation;

    @Value("${tw4.address.del}")
    private String address_del;

    @Transactional
    @Override
    public PrdAbAddressVO save(PrdAbAddressPayload payload) {
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //String result = httpUtil.sendSyncPost(address_operation, map);
        //String addressId = httpUtil.geResultData(result);
        //long addressIdV4 = 0;
        //if (StringUtils.hasText(addressId)) {
        //    if (StringUtil.isInteger(addressId)) {
        //        addressIdV4 = Long.valueOf(addressId);
        //    }
        //}
        if(payload.getDefaultAddress()!=null && payload.getDefaultAddress()){
            //当设置默认地址时要同时设置当前的默认地址为非默认
            Long bookId = payload.getBookId();
            List<PrdAbAddressVO> prdAbAddressVOS = queryList(bookId);
            for (PrdAbAddressVO prdAbAddressVO : prdAbAddressVOS) {
                if(prdAbAddressVO.getDefaultAddress()!=null && prdAbAddressVO.getDefaultAddress()){
                    PrdAbAddressPayload prdAbAddressPayload = PrdAbAddressConvert.INSTANCE.toPayload(prdAbAddressVO);
                    prdAbAddressPayload.setDefaultAddress(false);
                    prdAbAddressPayload.setObjectType("customer");
                    update(prdAbAddressPayload);
                }
            }
        }
        PrdAbAddressDO contactsDO = PrdAbAddressConvert.INSTANCE.toDo(payload);
        //contactsDO.setAddressIdV4(addressIdV4);
        contactsDO = dao.save(contactsDO);
        saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        return PrdAbAddressConvert.INSTANCE.toVo(contactsDO);
    }


    /**
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param logType    记录内容
     */
    void saveBaseLog(Long bookId, String objectType, String logType) {
//        Long customerId = dao.queryIdByBookId(bookId);
//        logService.saveNewLog(customerId, objectType, logType + "地址");

    }

    @Transactional
    @Override
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
        //String result = httpUtil.sendSyncGet(address_del, map);
        //httpUtil.geResultData(result);

        dao.delete(keys);
        saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    @Override
    public boolean update(PrdAbAddressPayload payload) {

        //同步到4.0
        //Long addressIdV4 = dao.queryTW4IdById(payload.getId());
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("id", addressIdV4);
        //String result = httpUtil.sendSyncPost(address_operation, map);
        //httpUtil.geResultData(result);

        PrdAbAddressDO contactsDO = PrdAbAddressConvert.INSTANCE.toDo(payload);
        //contactsDO.setAddressIdV4(addressIdV4);
        if(payload.getDefaultAddress()!=null && payload.getDefaultAddress()){
            //当设置默认地址时要同时设置当前的默认地址为非默认
            Long bookId = payload.getBookId();
            List<PrdAbAddressVO> prdAbAddressVOS = queryList(bookId);
            for (PrdAbAddressVO prdAbAddressVO : prdAbAddressVOS) {
                if(prdAbAddressVO.getDefaultAddress()!=null &&  prdAbAddressVO.getDefaultAddress()){
                    PrdAbAddressPayload prdAbAddressPayload = PrdAbAddressConvert.INSTANCE.toPayload(prdAbAddressVO);
                    prdAbAddressPayload.setDefaultAddress(false);
                    prdAbAddressPayload.setObjectType("customer");
//                    PrdAbAddressPayload payload1 = new PrdAbAddressPayload();
//                    payload1.setBookId(bookId);
//                    payload1.setId(prdAbAddressVO.getId());
//                    payload1.setDefaultAddress(false);
//                    payload1.setObjectType("customer");
                    update(prdAbAddressPayload);
                }
            }
        }
        dao.save(contactsDO);
        saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
        return true;
    }

    @Override
    public List<PrdAbAddressVO> queryList(Long bookId) {
        List<PrdAbAddressVO> contactsVOS = dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> transferSystemSelection(contactsVO));
        return contactsVOS;
    }

    @Override
    public List<PrdAbAddressVO> queryList(Long bookId, String addressType) {
        List<PrdAbAddressVO> contactsVOS = dao.queryList(bookId,addressType);
        contactsVOS.forEach(contactsVO -> transferSystemSelection(contactsVO));
        return contactsVOS;
    }

    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(PrdAbAddressVO vo) {
        vo.setAddressTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbAddressType.getCode(), vo.getAddressType()));
        vo.setCountryName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCountry.getCode(),vo.getCountry()));
    }
}
