package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgVersionPayload;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgVersionVO;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitesland.tw.tw5.server.prd.org.repo.*;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdOrgVersionDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgVersionRepo repo;
    private final PrdOrgDimensionRepo repoDimension;
    private final PrdOrgOrganizationRepo repoOrganization;
    private final PrdOrgOrganizationRefRepo repoOrganizationRef;
    private final PrdOrgRoleRepo repoRole;
    private final PrdOrgEmployeeRefRepo repoEmployeeRef;


    private final QPrdOrgVersionDO qdo = QPrdOrgVersionDO.prdOrgVersionDO;
    private final QPrdOrgDimensionDO qdoDimension = QPrdOrgDimensionDO.prdOrgDimensionDO;
    private final QPrdOrgOrganizationRefDO qdoOrganizationRef = QPrdOrgOrganizationRefDO.prdOrgOrganizationRefDO;
    private final QPrdOrgOrganizationDO qdoOrganization = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgRoleDO qdoRole = QPrdOrgRoleDO.prdOrgRoleDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    /**
     * 根据组织查询所有员工关系
     *
     * @param orgId
     * @return 结果
     */
    public List<PrdOrgEmployeeRefDO> queryOrgEmployeesByOrgId(Long orgId) {
        JPAQuery<PrdOrgEmployeeRefDO> jpaQuery = jpaQueryFactory.select(qdoEmployeeRef).from(qdoEmployeeRef);
        jpaQuery.where(qdoEmployeeRef.orgId.eq(orgId));
        jpaQuery.where(qdoEmployeeRef.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do集合
     * @return 保存后的对象
     */
    public List<PrdOrgEmployeeRefDO> saveEmployeeRefs(List<PrdOrgEmployeeRefDO> ados) {
        return repoEmployeeRef.saveAll(ados);
    }

    /**
     * 根据组织查询下属角色
     *
     * @param orgId
     * @return 结果
     */
    public List<PrdOrgRoleDO> queryOrgRolesByOrgId(Long orgId) {
        JPAQuery<PrdOrgRoleDO> jpaQuery = jpaQueryFactory.select(qdoRole).from(qdoRole);
        jpaQuery.where(qdoRole.orgId.eq(orgId));
        jpaQuery.where(qdoRole.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do集合
     * @return 保存后的对象
     */
    public List<PrdOrgRoleDO> saveRoles(List<PrdOrgRoleDO> ados) {
        return repoRole.saveAll(ados);
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do集合
     * @return 保存后的对象
     */
    public List<PrdOrgOrganizationRefDO> saveOrganizationRefs(List<PrdOrgOrganizationRefDO> ados) {
        return repoOrganizationRef.saveAll(ados);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgOrganizationDO saveOrganization(PrdOrgOrganizationDO ado) {
        return repoOrganization.save(ado);
    }

    /**
     * 根据key查询组织
     *
     * @param key
     * @return 结果
     */
    public PrdOrgOrganizationDO queryOrg(Long key) {
        JPAQuery<PrdOrgOrganizationDO> jpaQuery = jpaQueryFactory.select(qdoOrganization).from(qdoOrganization);
        jpaQuery.where(qdoOrganization.id.eq(key));
        jpaQuery.where(qdoOrganization.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据版本号查询
     *
     * @param code
     * @return 结果
     */
    public PrdOrgVersionDO queryVersionByCode(Long dimensionId, String code) {
        JPAQuery<PrdOrgVersionDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.versionNo.eq(code));
        jpaQuery.where(qdo.dimensionId.eq(dimensionId));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据维度查询下属组织关系
     *
     * @param dimensionId
     * @return 结果
     */
    public List<PrdOrgOrganizationRefDO> queryOrgListByDimensionId(Long dimensionId) {
        JPAQuery<PrdOrgOrganizationRefDO> jpaQuery = jpaQueryFactory.select(qdoOrganizationRef).from(qdoOrganizationRef);
        jpaQuery.where(qdoOrganizationRef.dimensionId.eq(dimensionId));
        jpaQuery.where(qdoOrganizationRef.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 查询维度
     *
     * @param dimensionId
     * @return 结果
     */
    public PrdOrgDimensionDO queryByDimensionId(Long dimensionId) {
        JPAQuery<PrdOrgDimensionDO> jpaQuery = jpaQueryFactory.select(qdoDimension).from(qdoDimension);
        jpaQuery.where(qdoDimension.id.eq(dimensionId));
        jpaQuery.where(qdoDimension.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgVersionDO save(PrdOrgVersionDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgDimensionDO saveDimension(PrdOrgDimensionDO ado) {
        return repoDimension.save(ado);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdOrgVersionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));


        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        if (payload.getChangeRecord() != null) {
            update.set(qdo.changeRecord, payload.getChangeRecord());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 根据维度查询所有版本
     *
     * @param dimensionId
     * @return 结果
     */
    public List<PrdOrgVersionVO> queryListByDimensionId(Long dimensionId) {
        JPAQuery<PrdOrgVersionVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgVersionVO.class,
                qdo.id,
                qdo.dimensionId,
                qdo.versionNo,
                qdo.changeRecord,
                qdo.createUserId,
                qdo.createTime
        )).from(qdo);
        jpaQuery.where(qdo.dimensionId.eq(dimensionId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.eq(key));
        return update.execute();
    }
}
