package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_menu")
@org.hibernate.annotations.Table(appliesTo = "prd_system_menu", comment = "系统菜单导航表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemMenuDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("上级菜单id")
    @Column()
    private Long parentId = 0L;

    @Comment("菜单编号")
    @Column()
    private String menuCode;

    @Comment("菜单名称")
    @Column()
    private String menuName;

    @Comment("菜单前端路由")
    @Column()
    private String portalRoute;

    @Comment("菜单图标")
    @Column()
    private String menuIcon;

    @Comment("菜单排序")
    @Column()
    private Integer sortIndex;

    @Comment("菜单状态")
    @Column()
    private Integer menuStatus;
}
