package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_selection", indexes = {@Index(name = "function_index", columnList = "function_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_system_selection", comment = "系统选择项表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemSelectionDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Comment("功能ID")
    @Column(name = "function_id")
    private Long functionId;


    @Comment("设置项KEY")
    @Column()
    private String selectionKey;

    @Comment("设置项名称")
    @Column()
    private String selectionName;


    @Comment("设置项内容国际化")
    @Column()
    private String selectionNameLocale;

    @Comment("是否允许修改")
    @Column()
    private String allowChange;

    @Comment("设置项值")
    @Column()
    private String selectionValue;

    @Comment("上级ID")
    @Column()
    private Long parentId;

    @Comment("排序号")
    @Column()
    private Integer sortNo;


    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;
    private String extString7;
    private String extString8;
    private String extString9;
    @Comment("省市区层级:1省，2市，3区")
    @Column
    private String extString10;
}
