/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.funConfig.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.TemplateUtil;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.funConfig.util.CodeGenDomainEnum;
import com.elitesland.tw.tw5.server.common.funConfig.util.ColUtil;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class CodeGenUtil {
    private static final String TIMESTAMP = "Timestamp";
    private static final String LOCALDATE = "LocalDate";
    private static final String LOCALDATETIME = "LocalDateTime";
    private static final String BIGDECIMAL = "BigDecimal";
    public static final String PK = "PRI";
    public static final String EXTRA = "auto_increment";

    public static void generatorCode(List<BusinessTableFieldsVO> columnInfos, BusinessTableVO genConfig, String projectModule, String apiGorupName, String packageName, String author, String moduleName, String prefix, boolean cover) throws IOException {
        Map<String, Object> genMap = CodeGenUtil.getGenMap(columnInfos, genConfig, apiGorupName, packageName, author, moduleName, prefix);
        TemplateEngine engine = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig("template", TemplateConfig.ResourceMode.CLASSPATH));
        List<String> templates = CodeGenUtil.getAdminTemplateNames();
        String type = projectModule;
        if (StringUtil.isBlank((CharSequence)type)) {
            type = CodeGenDomainEnum.TW.getCode();
        }
        for (String templateName : templates) {
            Template template = engine.getTemplate("generator/" + type + "/" + templateName + ".ftl");
            String rootPath = System.getProperty("user.dir");
            String filePath = CodeGenUtil.getAdminFilePath(templateName, moduleName, packageName, genMap.get("className").toString(), rootPath);
            assert (filePath != null);
            File file = new File(filePath);
            if (!cover && FileUtil.exist((File)file)) continue;
            CodeGenUtil.genFile(file, template, genMap);
        }
    }

    private static Map<String, Object> getGenMap(List<BusinessTableFieldsVO> columnInfos, BusinessTableVO genConfig, String apiGorupName, String packageName, String author, String moduleName, String prefix) {
        HashMap<String, Object> genMap = new HashMap<String, Object>(16);
        genMap.put("apiAlias", genConfig.getName());
        genMap.put("apiGroupName", ObjectUtils.isEmpty((Object)apiGorupName) ? "" : apiGorupName);
        genMap.put("package", packageName);
        genMap.put("moduleName", ObjectUtils.isEmpty((Object)moduleName) ? "" : "moduleName");
        genMap.put("author", ObjectUtils.isEmpty((Object)author) ? "" : "codegen");
        genMap.put("date", LocalDate.now().toString());
        genMap.put("tableName", genConfig.getTableName());
        String className = StringUtil.toCapitalizeCamelCase(genConfig.getTableName());
        String changeClassName = StringUtil.toCamelCase(genConfig.getTableName());
        if (StringUtil.isNotEmpty((CharSequence)prefix)) {
            className = StringUtil.toCapitalizeCamelCase(StrUtil.removePrefix((CharSequence)genConfig.getTableName(), (CharSequence)prefix));
            changeClassName = StringUtil.toCamelCase(StrUtil.removePrefix((CharSequence)genConfig.getTableName(), (CharSequence)prefix));
            changeClassName = StringUtil.uncapitalize((String)changeClassName);
        }
        genMap.put("className", className);
        genMap.put("changeClassName", changeClassName);
        genMap.put("hasTimestamp", false);
        genMap.put("hasLocalDate", false);
        genMap.put("hasLocalDateTime", false);
        genMap.put("queryHasTimestamp", false);
        genMap.put("hasBigDecimal", false);
        genMap.put("queryHasBigDecimal", false);
        genMap.put("hasQuery", false);
        genMap.put("auto", false);
        genMap.put("hasDict", false);
        genMap.put("hasDateAnnotation", false);
        ArrayList columns = new ArrayList();
        ArrayList queryColumns = new ArrayList();
        ArrayList dicts = new ArrayList();
        ArrayList betweens = new ArrayList();
        ArrayList isNotNullColumns = new ArrayList();
        for (BusinessTableFieldsVO column : columnInfos) {
            HashMap<String, Object> listMap = new HashMap<String, Object>(16);
            listMap.put("remark", ObjectUtils.isEmpty((Object)column.getFieldName()) ? "" : column.getFieldName());
            listMap.put("columnKey", column.getType());
            String colType = ColUtil.cloToJava(column.getType());
            String changeColumnName = StringUtil.toCamelCase(column.getField());
            String capitalColumnName = StringUtil.toCapitalizeCamelCase(column.getField());
            genMap.put("pkColumnType", "Long");
            if ("PK".equals(column.getExt2())) {
                genMap.put("pkColumnType", colType);
                genMap.put("pkChangeColName", changeColumnName);
                genMap.put("pkCapitalColName", capitalColumnName);
            }
            if (TIMESTAMP.equals(colType)) {
                genMap.put("hasTimestamp", true);
            }
            if (LOCALDATE.equals(colType)) {
                genMap.put("hasLocalDate", true);
            }
            if (LOCALDATETIME.equals(colType)) {
                genMap.put("hasLocalDateTime", true);
            }
            if (BIGDECIMAL.equals(colType)) {
                genMap.put("hasBigDecimal", true);
            }
            if (EXTRA.equals(column.getExt1())) {
                genMap.put("auto", true);
            }
            listMap.put("columnType", colType);
            listMap.put("columnName", column.getField());
            listMap.put("istNotNull", column.getNotNull());
            listMap.put("changeColumnName", changeColumnName);
            listMap.put("capitalColumnName", capitalColumnName);
            if (column.getNotNull().booleanValue()) {
                isNotNullColumns.add(listMap);
            }
            if (!StringUtil.isBlank((CharSequence)"=")) {
                listMap.put("queryType", "=");
                genMap.put("hasQuery", true);
                if (TIMESTAMP.equals(colType)) {
                    genMap.put("queryHasTimestamp", true);
                }
                if (BIGDECIMAL.equals(colType)) {
                    genMap.put("queryHasBigDecimal", true);
                }
                if ("between".equalsIgnoreCase("=")) {
                    betweens.add(listMap);
                } else {
                    queryColumns.add(listMap);
                }
            }
            if (PK.equals(column.getType())) continue;
            columns.add(listMap);
        }
        genMap.put("columns", columns);
        genMap.put("queryColumns", queryColumns);
        genMap.put("dicts", dicts);
        genMap.put("betweens", betweens);
        genMap.put("isNotNullColumns", isNotNullColumns);
        return genMap;
    }

    private static List<String> getAdminTemplateNames() {
        ArrayList<String> templateNames = new ArrayList<String>();
        templateNames.add("Controller");
        templateNames.add("Convert");
        templateNames.add("DO");
        templateNames.add("DAO");
        templateNames.add("Payload");
        templateNames.add("Query");
        templateNames.add("Repo");
        templateNames.add("Service");
        templateNames.add("ServiceImpl");
        templateNames.add("VO");
        return templateNames;
    }

    private static String getAdminFilePath(String templateName, String moduleName, String packageName, String className, String rootPath) {
        String projectPath = rootPath + File.separator + moduleName;
        String packagePath = projectPath + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
        if (!ObjectUtils.isEmpty((Object)packageName)) {
            packagePath = packagePath + packageName.replace(".", File.separator) + File.separator;
        }
        if ("Service".equals(templateName)) {
            return packagePath + "service" + File.separator + className + "Service.java";
        }
        if ("Payload".equals(templateName)) {
            return packagePath + "payload" + File.separator + className + "Payload.java";
        }
        if ("VO".equals(templateName)) {
            return packagePath + "vo" + File.separator + className + "VO.java";
        }
        if ("Query".equals(templateName)) {
            return packagePath + "query" + File.separator + className + "Query.java";
        }
        if ("Controller".equals(templateName)) {
            return packagePath + "controller" + File.separator + className + "Controller.java";
        }
        if ("Entity".equals(templateName)) {
            return packagePath + "domain" + File.separator + className + ".java";
        }
        if ("ServiceImpl".equals(templateName)) {
            return packagePath + "service" + File.separator + className + "ServiceImpl.java";
        }
        if ("DO".equals(templateName)) {
            return packagePath + "entity" + File.separator + className + "DO.java";
        }
        if ("DAO".equals(templateName)) {
            return packagePath + "dao" + File.separator + className + "DAO.java";
        }
        if ("Convert".equals(templateName)) {
            return packagePath + "convert" + File.separator + className + "Convert.java";
        }
        if ("Repo".equals(templateName)) {
            return packagePath + "repo" + File.separator + className + "Repo.java";
        }
        if ("QueryCriteria".equals(templateName)) {
            return packagePath + "service" + File.separator + "dto" + File.separator + className + "QueryCriteria.java";
        }
        if ("Mapper".equals(templateName)) {
            return packagePath + "service" + File.separator + "mapstruct" + File.separator + className + "Mapper.java";
        }
        if ("Repository".equals(templateName)) {
            return packagePath + "repository" + File.separator + className + "Repository.java";
        }
        return null;
    }

    private static void genFile(File file, Template template, Map<String, Object> map) throws IOException {
        Writer writer = null;
        try {
            FileUtil.touch((File)file);
            writer = new FileWriter(file);
            template.render(map, writer);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            assert (writer != null);
            writer.close();
        }
    }
}

