package com.elitesland.tw.tw5.server.prd.sale.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;


/**
 * 合同类别
 *
 * @author duwh
 * @date 2022/09/27
 */
@Entity(name = "sale_contract_category")
@Table(name = "sale_contract_category")
@org.hibernate.annotations.Table(appliesTo = "sale_contract_category", comment = "合同类别(模板分类)")
@Getter
@Setter
@ToString
@Where(clause = "delete_flag = 0")
public class SaleContractCategoryDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = -1187522405948092251L;

    /**
     * 名称
     */
    @Comment("名称")
    @Column()
    private String name;

    /**
     * 类别编号
     */
    @Comment("编号")
    @Column()
    private String categoryNo;

    /**
     * 图标
     */
    @Comment("图标")
    @Column()
    private String icon;

    /**
     * 隐藏标志 0：不隐藏，1：隐藏
     */
    @Column(
        name = "hidden_flag",
        columnDefinition = "int(10) default '0' comment '是否隐藏，0：不隐藏，1：隐藏' "
    )
    private Integer hiddenFlag;

    /**
     * 排序
     */
    @Comment("排序")
    @Column()
    private Integer sortNo;


    public SaleContractCategoryDO() {
    }

    public void copy(SaleContractCategoryDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
