/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.log.service;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.log.query.LogQuery;
import com.elitesland.tw.tw5.api.log.vo.LogVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.log.convert.LogConvert;
import com.elitesland.tw.tw5.server.log.entity.LogDO;
import com.elitesland.tw.tw5.server.log.repo.LogRepo;
import com.elitesland.tw.tw5.server.log.service.LogService;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class LogServiceImpl
implements LogService {
    private static final Logger log = LoggerFactory.getLogger(LogServiceImpl.class);
    private final LogRepo logRepo;

    @Override
    public PagingVO<LogVO> paging(LogQuery query) {
        Page page = this.logRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(LogConvert.INSTANCE::toVo));
    }

    @Override
    public List<LogVO> queryList(LogQuery query) {
        return LogConvert.INSTANCE.toVoList(this.logRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public LogDO queryByKey(Long key) {
        LogDO entity = (LogDO)((Object)this.logRepo.findById(key).get());
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public LogDO insert(LogDO entityDo) {
        return (LogDO)((Object)this.logRepo.save((Object)entityDo));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public LogDO update(LogDO entityDo) {
        LogDO entity = (LogDO)((Object)this.logRepo.findById(entityDo.getId()).get());
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        entity.copy(entityDo);
        return (LogDO)((Object)this.logRepo.save((Object)entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.logRepo.findById(id);
                if (!optional.isEmpty()) {
                    LogDO entity = (LogDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.logRepo.save((Object)entity);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(ProceedingJoinPoint joinPoint, LogDO log) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = joinPoint.getTarget().getClass().getName() + "." + signature.getName() + "()";
        Method method = signature.getMethod();
        log.setAddress(StringUtil.getCityInfo(log.getRequestIp()));
        log.setMethod(methodName);
        log.setParams(this.getParameter(method, joinPoint.getArgs()));
        this.logRepo.save((Object)log);
    }

    @Override
    public void delete(List<Long> keys) {
        this.logRepo.deleteAllById(keys);
    }

    private String getParameter(Method method, Object[] args) {
        ArrayList argList = new ArrayList();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            String key = parameters[i].getName();
            map.put(key, args[i]);
            argList.add(map);
        }
        if (argList.isEmpty()) {
            return "";
        }
        return argList.size() == 1 ? JSONUtil.toJsonStr(argList.get(0)) : JSONUtil.toJsonStr(argList);
    }

    public LogServiceImpl(LogRepo logRepo) {
        this.logRepo = logRepo;
    }
}

