package com.elitesland.tw.tw5.server.log.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.log.query.LogQuery;
import com.elitesland.tw.tw5.api.log.vo.LogVO;
import com.elitesland.tw.tw5.server.log.entity.LogDO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.scheduling.annotation.Async;

import java.util.List;

/**
 * 日志记录
 *
 * @author duwh
 * @date 2023-02-03
 */
public interface LogService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link LogVO}>
     */
    PagingVO<LogVO> paging(LogQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link LogVO}>
     */
    List<LogVO> queryList(LogQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link LogVO}
     */
    LogDO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link LogVO}
     */
    LogDO insert(LogDO payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link LogVO}
     */
    LogDO update(LogDO payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 异步保存
     *
     * @param joinPoint 连接点
     * @param log       日志
     */
    @Async
    void save(ProceedingJoinPoint joinPoint, LogDO log);

    /**
     * 物理删除
     *
     * @param keys 主键集合
     */
    void delete(List<Long> keys);
}
