package com.elitesland.tw.tw5.server.prd.common;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdFsmFileRefVO;
import lombok.RequiredArgsConstructor;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class FileUtil {

    private final FileService fileService;

    public Object getFileDatas(String fileCodes) {
        if (StringUtils.hasText(fileCodes)) {
            List<String> fileCodeList = Arrays.asList(fileCodes.split(","));
            return fileService.query(fileCodeList).getData();
        }
        return null;

    }

    public Map<String, List<FileObjRespVO<T>>> getFileDataMap(List<PrdFsmFileRefVO> prdFsmFileRefDOList) {
        if (!CollectionUtils.isEmpty(prdFsmFileRefDOList)) {
            final List<String> fileCodeList = prdFsmFileRefDOList.stream().map(PrdFsmFileRefVO::getFileCode).collect(Collectors.toList());
            List<FileObjRespVO<T>> list = (List<FileObjRespVO<T>>) fileService.query(fileCodeList).getData();
            final Map<String, List<FileObjRespVO<T>>> listMap = list.stream().collect(Collectors.groupingBy(FileObjRespVO::getFileCode));
            return listMap;
        }
        return null;

    }
}
