/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgVersionPayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgVersionService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgVersionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgVersionConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgVersionDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgVersionDO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdOrgVersionServiceImpl
implements PrdOrgVersionService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgVersionServiceImpl.class);
    private final PrdOrgVersionDAO dao;

    @Transactional
    public PrdOrgVersionVO insert(PrdOrgVersionPayload payload) {
        PrdOrgDimensionDO dimensionDO = this.dao.queryByDimensionId(payload.getDimensionId());
        if (dimensionDO.getVersionId() == null || dimensionDO.getVersionId() == 0L) {
            if (this.dao.queryVersionByCode(payload.getDimensionId(), payload.getVersionNo()) != null) {
                throw TwException.error("", "\u7248\u672c\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
            PrdOrgVersionDO ado = PrdOrgVersionConvert.INSTANCE.toDo(payload);
            ado = this.dao.save(ado);
            PrdOrgDimensionDO dimensionDONEW = (PrdOrgDimensionDO)dimensionDO.clone();
            boolean aa = dimensionDONEW == dimensionDO;
            dimensionDONEW.setId(0L);
            dimensionDONEW.setVersionId(ado.getId());
            dimensionDONEW = this.dao.saveDimension(dimensionDONEW);
            HashMap<Long, Long> orgMap = new HashMap<Long, Long>();
            ArrayList<PrdOrgOrganizationRefDO> orgRefDOS = new ArrayList<PrdOrgOrganizationRefDO>();
            List<PrdOrgOrganizationRefDO> orgOrganizationRefDOS = this.dao.queryOrgListByDimensionId(payload.getDimensionId());
            for (PrdOrgOrganizationRefDO refDO : orgOrganizationRefDOS) {
                PrdOrgOrganizationDO prdOrgOrganizationDO = this.dao.queryOrg(refDO.getOrgId());
                if (prdOrgOrganizationDO == null) continue;
                PrdOrgOrganizationDO prdOrgOrganizationDONEW = (PrdOrgOrganizationDO)prdOrgOrganizationDO.clone();
                prdOrgOrganizationDONEW.setId(0L);
                prdOrgOrganizationDONEW.setChangeId(prdOrgOrganizationDO.getId());
                prdOrgOrganizationDONEW.setDimensionId(dimensionDONEW.getId());
                prdOrgOrganizationDONEW.setIsCopy(1);
                prdOrgOrganizationDONEW = this.dao.saveOrganization(prdOrgOrganizationDONEW);
                orgMap.put(prdOrgOrganizationDO.getId(), prdOrgOrganizationDONEW.getId());
                orgRefDOS.add((PrdOrgOrganizationRefDO)refDO.clone());
            }
            for (PrdOrgOrganizationRefDO refDONEW : orgRefDOS) {
                refDONEW.setId(0L);
                refDONEW.setOrgId((Long)orgMap.get(refDONEW.getOrgId()));
                refDONEW.setDimensionId(dimensionDONEW.getId());
                refDONEW.setParentId((Long)orgMap.get(refDONEW.getParentId()));
                refDONEW.setIsCopy(1);
            }
            this.dao.saveOrganizationRefs(orgRefDOS);
            ArrayList<PrdOrgRoleDO> prdOrgRoleDOAll = new ArrayList<PrdOrgRoleDO>();
            ArrayList<PrdOrgEmployeeRefDO> prdOrgEmployeeRefDOAll = new ArrayList<PrdOrgEmployeeRefDO>();
            for (Map.Entry entry : orgMap.entrySet()) {
                List<PrdOrgRoleDO> prdOrgRoleDOS = this.dao.queryOrgRolesByOrgId((Long)entry.getKey());
                for (PrdOrgRoleDO roleDO : prdOrgRoleDOS) {
                    PrdOrgRoleDO roleDONEW = (PrdOrgRoleDO)roleDO.clone();
                    roleDONEW.setChangeId((Long)entry.getKey());
                    roleDONEW.setOrgId((Long)entry.getValue());
                    roleDONEW.setIsCopy(1);
                    roleDONEW.setId(0L);
                    prdOrgRoleDOAll.add(roleDONEW);
                }
                List<PrdOrgEmployeeRefDO> prdOrgEmployeeRefDOS = this.dao.queryOrgEmployeesByOrgId((Long)entry.getKey());
                for (PrdOrgEmployeeRefDO employeeRefDO : prdOrgEmployeeRefDOS) {
                    PrdOrgEmployeeRefDO employeeRefDONEW = (PrdOrgEmployeeRefDO)employeeRefDO.clone();
                    employeeRefDONEW.setOrgId((Long)entry.getValue());
                    employeeRefDONEW.setIsCopy(1);
                    employeeRefDONEW.setId(0L);
                    prdOrgEmployeeRefDOAll.add(employeeRefDONEW);
                }
            }
            this.dao.saveRoles(prdOrgRoleDOAll);
            this.dao.saveEmployeeRefs(prdOrgEmployeeRefDOAll);
            return PrdOrgVersionConvert.INSTANCE.toVo(ado);
        }
        throw TwException.error("", "\u5386\u53f2\u6570\u636e\u4e0d\u53ef\u5907\u4efd");
    }

    @Transactional
    public Long update(PrdOrgVersionPayload payload) {
        PrdOrgVersionDO versionDO = this.dao.queryVersionByCode(payload.getDimensionId(), payload.getVersionNo());
        if (versionDO != null && versionDO.getId().longValue() != payload.getId().longValue()) {
            throw TwException.error("", "\u7248\u672c\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        return this.dao.updateByKeyDynamic(payload);
    }

    public List<PrdOrgVersionVO> queryList(Long dimensionId) {
        return this.dao.queryListByDimensionId(dimensionId);
    }

    @Transactional
    public boolean deleteSoft(Long key) {
        return this.dao.deleteSoft(key) >= 0L;
    }

    public PrdOrgVersionServiceImpl(PrdOrgVersionDAO dao) {
        this.dao = dao;
    }
}

