package com.elitesland.tw.tw5.server.common.QyWx.service;

import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxSchedulePayload;
import com.elitesland.tw.tw5.server.common.BeanMapTool;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.RedisCacheUtil;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zoey
 * @Description:企业微信通讯工具
 * @date 2022/4/21 - 20:21
 */
@Component
@RequiredArgsConstructor
@Slf4j
public class QyWxCommunicationService {

    private final HttpUtil httpUtil;
    private final RedisCacheUtil redisCacheUtil;
    private final BeanMapTool beanMapTool;


//    private static final String USER_SECRET="W2de1vOKjM1ITuacXTveQ5JzCmBn54--kPP_qq7j978";
    private static final String TW5_SECRET = "LC-usNy8ldPutPJr22222Um3ES81hroVJStOyL0E";
    private static final String EL_CORP_ID = "wx7760085f0222227";
    private static final String QYAPI = "https://qyapi.weixin.qq.com/cgi-bin";
    private static final Integer AGENT_ID = 1000030;
    private final PrdMessageConfigDAO prdMessageConfigDAO;

    /*
     * @Author Zoey
     * @Description 获取token
     * @Date 23:24 2022/4/21
     * @Param corpId 企业id, corpsecret 应用secret, appName 应用名称
     * @return java.lang.String
     **/
    public String getAccessToken(String corpsecret, String corpid) {
        //获取accessToken
//        String accessToken = redisCacheUtil.get("wx_access_token"+corpsecret);
        String accessToken = null;
        if (accessToken == null) {
            Map<String, Object> uriMap = new HashMap<>();
            uriMap.put("corpid", corpid);
            uriMap.put("corpsecret", corpsecret);
            String result = httpUtil.sendGet("https://qyapi.weixin.qq.com/cgi-bin/gettoken", uriMap);
            accessToken = httpUtil.geStrItem(result, "access_token", "获取企业微信access_token失败！");
            //查询accessToken缓存，如果超时了就重新获取
//            redisCacheUtil.add("wx_access_token"+corpsecret,accessToken,3600, TimeUnit.SECONDS);
        }
        return accessToken;
    }


    private String getTw5AccessToken() {
        return getAccessToken(TW5_SECRET, EL_CORP_ID);
    }


    /*
     * @Author Zoey
     * @Description 查询日历
     * @Date 23:24 2022/4/21
     **/
    public Map<String, Object> getCalendar(String calId) {
        log.warn("[企业微信同步]：【未开启】查询日历");
        //Map<String, Object> idsMap = new HashMap<>();
        //List<String> list = Collections.singletonList(calId);
        //idsMap.put("cal_id_list", list);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/calendar/get?access_token=" + accessToken, idsMap);
        //Map parse = (Map) JSON.parse(result);
        //if (parse.get("errcode").equals(0)) {
        //    List<Map<String, Object>> calendarList = (List<Map<String, Object>>) parse.get("calendar_list");
        //    if (calendarList != null) {
        //        return calendarList.get(0);
        //    }
        //} else {
        //    throw TwException.error("", "查询企业微信端日历失败");
        //}
        return null;
    }


    /*
     * @Author Zoey
     * @Description 保存日历
     * @Date 23:24 2022/4/21
     **/
    public String saveCalendar(QyWxCalendarPayload payload) {
        log.warn("[企业微信同步]：【未开启】保存日历");
        return "";
        //Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        //Map<String, Object> calanderMap = new HashMap<>();
        //calanderMap.put("calendar", objectMap);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/calendar/add?access_token=" + accessToken, calanderMap);
        //return httpUtil.geStrItem(result, "cal_id", "日历同步插入到企业微信失败！");
    }

    /*
     * @Author Zoey
     * @Description 更新日历
     * @Date 23:24 2022/4/21
     **/
    public void updateCalendar(QyWxCalendarPayload payload) {

        log.warn("[企业微信同步]：【未开启】更新日历");
        //Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        //Map<String, Object> calanderMap = new HashMap<>();
        //calanderMap.put("calendar", objectMap);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/calendar/update?access_token=" + accessToken, calanderMap);
        //httpUtil.geStrItem(result, "cal_id", "日历同步更新到企业微信失败！");
    }

    /*
     * @Author Zoey
     * @Description 删除日历
     * @Date 13:24 2022/5/6
     **/
    public void deleteCalendar(String calId) {

        log.warn("[企业微信同步]：【未开启】删除日历");
        //Map<String, Object> idMap = new HashMap<>();
        //idMap.put("cal_id", calId);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/calendar/del?access_token=" + accessToken, idMap);
        //httpUtil.geStrItem(result, "cal_id", "从企业微信删除日历失败！");
    }


    /*
     * @Author Zoey
     * @Description 查询日程
     * @Date 23:24 2022/4/21
     **/
    public Map<String, Object> getSchedule(String scheduleId) {

        log.warn("[企业微信同步]：【未开启】查询日程");
        //Map<String, Object> idsMap = new HashMap<>();
        //List<String> list = Collections.singletonList(scheduleId);
        //idsMap.put("schedule_id_list", list);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/get?access_token=" + accessToken, idsMap);
        //Map parse = (Map) JSON.parse(result);
        //if (parse.get("errcode").equals(0)) {
        //    List<Map<String, Object>> scheduleList = (List<Map<String, Object>>) parse.get("schedule_list");
        //    if (scheduleList != null) {
        //        return scheduleList.get(0);
        //    }
        //} else {
        //    throw TwException.error("", "查询企业微信端日程失败");
        //}
        return null;
    }


    /*
     * @Author Zoey
     * @Description 保存日程
     * @Date 21:50 2022/4/23
     **/
    public String saveSchedule(QyWxSchedulePayload payload) {

        log.warn("[企业微信同步]：【未开启】保存日程");
        return "";
        //Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        //Map<String, Object> scheduleMap = new HashMap<>();
        //scheduleMap.put("schedule", objectMap);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/add?access_token=" + accessToken, scheduleMap);
        //return httpUtil.geStrItem(result, "schedule_id", "日程同步插入到企业微信失败！");
    }

    /*
     * @Author Zoey
     * @Description 更新日程
     * @Date 21:50 2022/4/23
     **/
    public void updateSchedule(QyWxSchedulePayload payload) {

        log.warn("[企业微信同步]：【未开启】更新日程");
        //Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        //Map<String, Object> scheduleMap = new HashMap<>();
        //scheduleMap.put("schedule", objectMap);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/update?access_token=" + accessToken, scheduleMap);
        //httpUtil.geStrItem(result, "schedule_id", "日程同步到更新企业微信失败！");
    }

    /*
     * @Author Zoey
     * @Description 删除日日程
     * @Date 13:24 2022/5/6
     **/
    public void deleteSchedule(String scheduleId) {
        log.warn("[企业微信同步]：【未开启】删除日日程");

        //Map<String, Object> idMap = new HashMap<>();
        //idMap.put("schedule_id", scheduleId);
        //String accessToken = getTw5AccessToken();
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/del?access_token=" + accessToken, idMap);
        //httpUtil.geStrItem(result, "schedule_id", "从企业微信删除日程失败！");
    }


    /*
     * @Author Zoey
     * @Description 根据手机号获取用户的userId(暂时不用)
     * @Date 16:38 2022/4/23
     * @Param [java.lang.String]
     * @return void
     **/
    public String getQyWxuserid(String mobile) {
        log.warn("[企业微信同步]：【未开启】根据手机号获取用户的userId");
        //String accessToken = getTw5AccessToken();
        //Map<String, Object> stringObjectMap = new HashMap<>();
        //stringObjectMap.put("mobile", mobile);
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/user/getuserid?access_token=" + accessToken, stringObjectMap);
        //Map parse = (Map) JSON.parse(result);
        //if (parse.get("errcode").equals(0)) {
        //    if (parse.get("userid") != null) {
        //        return parse.get("userid") + "";
        //    }
        //}
        return "";
    }


    /*
     * @Author Zoey
     * @Description
     * 参考https://blog.csdn.net/a201692/article/details/123530529
     * 1.同步企业微信用户，获取jobid,并存储到redis
     * 2.等待回调
     * 3.用jobid去获取结果
     * @Date 20:17 2022/4/23
     * @Param []
     * @return java.lang.String
     **/
    public void exportUsersRequest() {

        log.warn("[企业微信同步]：【未开启】同步企业微信用户");

        //String accessToken = getTw5AccessToken();
        //Map<String, Object> stringObjectMap = new HashMap<>();
        //stringObjectMap.put("block_size", 1000);
        //stringObjectMap.put("encoding_aeskey", "IFxAxLOaqxfbYXW1U78KJy7x4pjfG4Fd5UKvjAdL1cx");
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/export/simple_user?access_token=" + accessToken, stringObjectMap);
        //String jobid = httpUtil.geStrItem(result, "jobid", "发起企业微信用户同步失败！");
        //redisCacheUtil.add("wx_user_job_id", jobid, 3600, TimeUnit.SECONDS);
    }


    /*
     * @Author Zoey
     * @Description  根据jobid 执行导出(成员，成员详情，部门，标签成员)
     * @Date 20:49 2022/4/23
     * @Param []
     * @return void
     **/
    public void exportUsersExport() {

        log.warn("[企业微信同步]：【未开启】根据jobid 执行导出(成员，成员详情，部门，标签成员)");
        ////获取redis-jobid
        //String jobid = redisCacheUtil.get("wx_user_job_id");
        //String accessToken = getTw5AccessToken();
        //Map<String, Object> stringObjectMap = new HashMap<>();
        //Map<String, Object> uriMap = new HashMap<>();
        //uriMap.put("jobid", jobid);
        //uriMap.put("access_token", accessToken);
        //String result = httpUtil.sendGet("https://qyapi.weixin.qq.com/cgi-bin/export/get_result", uriMap);
        //Map parse = (Map) JSON.parse(result);
        //if (parse.get("errcode").equals(0) && parse.get("status").equals(2)) {
        //    Object[] data_lists = (Object[]) parse.get("data_list");
        //    //TODO:需要看到数据，对数据进行处理后再持久化到数据库
        //} else {
        //    throw TwException.error("", "企业微信导出结果获取失败！");
        //}
    }

    /*
     * @Author wanngding
     * @Description  发送消息
     * @Date 20:49 2022/4/23
     * @Param []
     * @return void
     **/
    public void sendMessageToUser(Map<String, Object> map) {

        log.warn("[企业微信同步]：【未开启】发送消息");

        //String accessToken = getTw5AccessToken();
        //map.put("agentid", AGENT_ID);
        //String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessToken, map);
        //Map parse = (Map) JSON.parse(result);
        //if (!parse.get("errcode").equals(0)) {
        //    throw TwException.error("", "发送企业信息失败！");
        //}
    }


    /**
     * 发送消息给用户
     *
     * @param userIdList 用户id列表
     * @param content    内容
     */
    public void sendMessageToUser(List<Long> userIdList, String content) {

        log.warn("[企业微信同步]：【未开启】发送消息给用户");

        //if (!CollectionUtils.isEmpty(userIdList) && StringUtils.hasText(content)) {
        //    List<String> weComs = prdMessageConfigDAO.queryUserWeComByIds(userIdList);
        //    String touser = org.apache.commons.lang3.StringUtils.join(weComs.stream().filter(weCom -> StringUtils.hasText(weCom)).collect(Collectors.toList()), "|");
        //    Map<String, Object> contentMap = new HashMap<>();
        //    contentMap.put("content", content);
        //    Map<String, Object> map = new HashMap<>();
        //    map.put("touser", touser);
        //    map.put("msgtype", "text");
        //    map.put("text", contentMap);
        //    String accessToken = getTw5AccessToken();
        //    map.put("agentid", AGENT_ID);
        //    String result = httpUtil.sendPost("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessToken, map);
        //    Map parse = (Map) JSON.parse(result);
        //    if (!parse.get("errcode").equals(0)) {
        //        throw TwException.error("", "发送企业信息失败！");
        //    }
        //}
    }

    /**
     * 发送消息给用户
     *
     * @param userId  用户id
     * @param content 内容
     */
    public void sendMessageToUser(Long userId, String content) {
        if (null != userId) {
            List<Long> userIdList = new ArrayList<>();
            userIdList.add(userId);
            sendMessageToUser(userIdList, content);
        }
    }

}
