package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgCompanyNoticePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgCompanyNoticeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyNoticeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyNoticeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.crontask.CmadCronTask;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSettingEnum;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgCompanyNoticeConvert;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyNoticeDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
//import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgCompanyNoticeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgCompanyNoticeRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgCompanyNoticeServiceImpl implements PrdOrgCompanyNoticeService {
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgCompanyNoticeDAO dao;
//    private final CrmActActivityDAO daoActivity;
    private final PrdMessageConfigDAO messageConfigDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgCompanyNoticeRepo repo;
    //    // @DubboReference(version = "${provider.service.version}")
//    private SysUserRpcService sysUserService;

    /**
     * 核对时间表达式
     *
     * @param payload
     */
    void checkTriggerTime(PrdOrgCompanyNoticePayload payload) {
        if (StringUtils.hasText(payload.getNoticeType()) && "ACTIVITY".equals(payload.getNoticeType())) {
            if (StringUtils.hasText(payload.getTriggerTimeExpression())) {
                throw TwException.error("", "活动公告不支持定时发布，请核验！");
            }
            if (!StringUtils.hasText(payload.getSourceId())) {
                throw TwException.error("", "资源id不存在，请核验！");
            }
        } else {
            if (StringUtils.hasText(payload.getTriggerTimeExpression())) {
                if (!CronExpression.isValidExpression(payload.getTriggerTimeExpression())) {
                    throw TwException.error("", "无效的时间表达式格式");
                }
            }
        }
    }

    @Override
    @Transactional
    public PrdOrgCompanyNoticeVO insert(PrdOrgCompanyNoticePayload payload) {
        //核对时间表达式
        checkTriggerTime(payload);

        payload.setReadAmount(0L);
        payload.setPublishFlag(0);
        payload.setChangeTime(LocalDateTime.now());

        PrdOrgCompanyNoticeDO ado = PrdOrgCompanyNoticeConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        return PrdOrgCompanyNoticeConvert.INSTANCE.toVo(ado);
    }

    @Override
    @Transactional
    public PrdOrgCompanyNoticeVO update(PrdOrgCompanyNoticePayload payload) {
        //核对时间表达式
        checkTriggerTime(payload);

        PrdOrgCompanyNoticeDO ado = PrdOrgCompanyNoticeConvert.INSTANCE.toDo(payload);
        ado.setChangeTime(LocalDateTime.now());
        ado = dao.save(ado);
        return PrdOrgCompanyNoticeConvert.INSTANCE.toVo(ado);
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        dao.deleteSoft(keys);
    }

    @Override
    public PrdOrgCompanyNoticeVO queryByKey(Long key) {
        PrdOrgCompanyNoticeVO prdOrgCompanyNoticeVO = dao.queryByKey(key);
        // 增加预览量
        prdOrgCompanyNoticeVO.setReadAmount(prdOrgCompanyNoticeVO.getReadAmount() + 1);
        PrdOrgCompanyNoticeDO prdOrgCompanyNoticeDO = PrdOrgCompanyNoticeConvert.INSTANCE.toDo(prdOrgCompanyNoticeVO);
        dao.save(prdOrgCompanyNoticeDO);
        transaction(Collections.singletonList(prdOrgCompanyNoticeVO));
        return prdOrgCompanyNoticeVO;
    }

    @Override
    public PagingVO<PrdOrgCompanyNoticeVO> paging(PrdOrgCompanyNoticeQuery query) {
        PagingVO<PrdOrgCompanyNoticeVO> paging = dao.queryPaging(query);
        List<PrdOrgCompanyNoticeVO> records = paging.getRecords();
        transaction(records);
        return paging;
    }

    @Override
    @Transactional
    public Boolean publish(List<Long> keys) {
        List<PrdOrgCompanyNoticeDO> noticeDOS = dao.queryByKeys(keys, 0);
        if (ObjectUtils.isEmpty(noticeDOS)) {
            throw TwException.error("", "仅支持未发布公告");
        }
        dao.updatePublishFlagByIds(keys, 1);
        //活动id
        List<Long> activityId = new ArrayList<>();
        //定时任务的公告
        List<PrdOrgCompanyNoticeDO> timeNoticeDOs = new ArrayList<>();
        noticeDOS.forEach(noticeDO -> {
            if (StringUtils.hasText(noticeDO.getTriggerTimeExpression()) || (StringUtils.hasText(noticeDO.getNoticeType()) && "ACTIVITY".equals(noticeDO.getNoticeType()))) {
                if (StringUtils.hasText(noticeDO.getNoticeType()) && "ACTIVITY".equals(noticeDO.getNoticeType())) {
                    activityId.add(Long.valueOf(noticeDO.getSourceId()));
                } else {
                    timeNoticeDOs.add(noticeDO);
                }

            }

        });
//        //修改活动已发布
//        if (activityId.size() > 0) {
//            daoActivity.updataReleaseByIds(activityId, 2);
//        }
        //创建定时任务
        if (timeNoticeDOs.size() > 0) {
            timeNoticeDOs.forEach(noticeDO -> {
                createXXLJob(noticeDO);
            });

        }
        return true;
    }

    /*
    创建定时任务
     */
    void createXXLJob(PrdOrgCompanyNoticeDO ado) {

        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAuthor(ado.getCreator());
        xxlJobInfo.setJobGroup(Integer.valueOf(cacheUtil.getSystemSetting(FunctionSettingEnum.JOB_GROUP.getCode()).getSettingValue()));
        xxlJobInfo.setJobCron(ado.getTriggerTimeExpression());
        xxlJobInfo.setJobDesc(ado.getNoticeTitle());
        xxlJobInfo.setExecutorHandler(CmadCronTask.companyNoticeXxlJobValue);
        xxlJobInfo.setExecutorParam(ado.getId() + "");
        xxlJobInfo.setTriggerStatus(1);
        messageConfigDAO.saveXxlJob(xxlJobInfo);
    }

    @Override
    @Transactional
    public Boolean revoke(List<Long> keys) {
        List<PrdOrgCompanyNoticeDO> noticeDOS = dao.queryByKeys(keys, 1);
        if (ObjectUtils.isEmpty(noticeDOS)) {
            throw TwException.error("", "仅支持已发布公告撤回");
        }
        dao.updatePublishFlagByIds(keys, 0);
        List<String> timeNoticeIds = new ArrayList<>();
        noticeDOS.forEach(noticeDO -> {
            if (StringUtils.hasText(noticeDO.getTriggerTimeExpression()) && (!StringUtils.hasText(noticeDO.getNoticeType()) || !"ACTIVITY".equals(noticeDO.getNoticeType()))) {
                timeNoticeIds.add(noticeDO.getId() + "");
            }
        });
        //删除定时任务
        if (timeNoticeIds.size() > 0) {
            messageConfigDAO.deleteXxlJobById(timeNoticeIds);
        }
        return true;
    }

    @Override
    public List<PrdOrgCompanyNoticeVO> queryList(PrdOrgCompanyNoticeQuery query) {
        List<PrdOrgCompanyNoticeVO> vos = dao.queryListDynamic(query);
        transaction(vos);
        return vos;
    }

    @Transactional
    @Override
    public void companyNoticeJobHandler(String param) {
        System.out.println("companyNoticeJobHandler param::" + param);
        if (StringUtil.isInteger(param)) {
            repo.updataCompanyNoticeTime(Long.valueOf(param), LocalDateTime.now());
        }
    }

    private void transaction(List<PrdOrgCompanyNoticeVO> list) {
        // 查询人员信息
        List<Long> userIdList = new ArrayList<>();
        list.stream().forEach(e -> {
            if (!ObjectUtils.isEmpty(e.getNoticeAuthorUserId())) {
                userIdList.add(e.getNoticeAuthorUserId());
            }
        });
        List<PrdOrgEmployeeVO> employeeVOS = employeeDAO.queryMobileList(userIdList);
        //   List<SysUserVO> sysUserVOS = sysUserService.getByIds(userIdList);
        Map<Long, PrdOrgEmployeeVO> sysUserVOMap = employeeVOS.stream().collect(Collectors.toMap(PrdOrgEmployeeVO::getUserId, Function.identity()));
        for (PrdOrgCompanyNoticeVO vo : list) {
            // 关于人的翻译，目前没有什么公共查询的方法,暂时只能用这个了，看之后用什么替换
            if (!ObjectUtils.isEmpty(vo.getNoticeAuthorUserId())) {
                PrdOrgEmployeeVO sysUser = sysUserVOMap.get(vo.getNoticeAuthorUserId());
                if (!ObjectUtils.isEmpty(sysUser)) {
                    vo.setNoticeAuthor(sysUser.getEmployeeName());
                }
            }
        }
    }
}
