/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ObjectUtils;

public class SqlUtil {
    private static List<OrderItem> orderse = null;

    public static String toSqlLikeString(String value) {
        return "%" + value + "%";
    }

    public static List<OrderItem> getOrderse() {
        if (orderse == null) {
            orderse = new ArrayList<OrderItem>();
            orderse.add(OrderItem.asc((String)"sortIndex"));
            orderse.add(OrderItem.desc((String)"createTime"));
        }
        return orderse;
    }

    public static <T> OrderSpecifier<?>[] getSortedColumn(EntityPathBase<T> pathBase, List<OrderItem> orders) {
        if (orders == null || orders.size() == 0) {
            SimplePath fieldPath = Expressions.path(String.class, pathBase, (String)"createTime");
            return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, (Expression)fieldPath)};
        }
        OrderSpecifier[] orderSpecifiers = new OrderSpecifier[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            OrderItem orderItem = orders.get(i);
            Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
            SimplePath fieldPath = Expressions.path(String.class, pathBase, (String)orderItem.getColumn());
            orderSpecifiers[i] = new OrderSpecifier(order, (Expression)fieldPath);
        }
        return orderSpecifiers;
    }

    public static <T> void handleCommonJpaQuery(JPAQuery<T> jpaQuery, QBaseModel qBaseModel, TwQueryParam query) {
        jpaQuery.where((Predicate)qBaseModel.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)qBaseModel.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)qBaseModel.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.goe((Comparable)query.getCreateTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.loe((Comparable)query.getCreateTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((Predicate)qBaseModel.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
    }

    public static void updateCommonJpaQuery(JPAUpdateClause update, QBaseModel qBaseModel) {
        SysUserDTO userDTO = GlobalUtil.getLoginUser();
        update.set((Path)qBaseModel.modifyUserId, (Object)userDTO.getId());
        update.set((Path)qBaseModel.updater, (Object)userDTO.getFirstName());
        update.set((Path)qBaseModel.modifyTime, (Object)LocalDateTime.now());
    }
}

