/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemWorkTypeQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemWorkTypeDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemWorkTypeDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemWorkTypeRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemWorkTypeDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemWorkTypeRepo repo;
    private final QPrdSystemWorkTypeDO qdo = QPrdSystemWorkTypeDO.prdSystemWorkTypeDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    public List<PrdSystemWorkTypeDO> saveAll(List<PrdSystemWorkTypeDO> ados) {
        return this.repo.saveAll(ados);
    }

    public PrdSystemWorkTypeDO save(String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        PrdSystemWorkTypeDO prdSystemWorkTypeDO = new PrdSystemWorkTypeDO(sysType, sysWork, sysLevel, unitPrice);
        return (PrdSystemWorkTypeDO)this.repo.save(prdSystemWorkTypeDO);
    }

    public long updateByKeyDynamic(Long key, String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        if (sysType != null) {
            update.set((Path)this.qdo.sysType, (Object)sysType);
        }
        if (sysWork != null) {
            update.set((Path)this.qdo.sysWork, (Object)sysWork);
        }
        if (sysLevel != null) {
            update.set((Path)this.qdo.sysLevel, (Object)sysLevel);
        }
        if (unitPrice != null) {
            update.set(this.qdo.unitPrice, (Object)unitPrice);
        }
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    private JPAQuery<PrdSystemWorkTypeVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemWorkTypeVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.sysType, this.qdo.sysWork, this.qdo.sysLevel, this.qdo.unitPrice, this.qdo.createUserId, this.qdo.createTime, this.qdoEmployee.employeeName.as("createUserName")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdo.createUserId.eq(this.qdoEmployee.userId));
    }

    public List<PrdSystemWorkTypeVO> queryList() {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdSystemWorkTypeVO> getJpaQueryWhere(PrdSystemWorkTypeQuery query) {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getSysType())) {
            jpaQuery.where((Predicate)this.qdo.sysType.eq((Object)query.getSysType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSysWork())) {
            jpaQuery.where((Predicate)this.qdo.sysWork.eq((Object)query.getSysWork()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSysLevel())) {
            jpaQuery.where((Predicate)this.qdo.sysLevel.eq((Object)query.getSysLevel()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public PagingVO<PrdSystemWorkTypeVO> queryPaging(PrdSystemWorkTypeQuery query) {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public PrdSystemWorkTypeDAO(JPAQueryFactory jpaQueryFactory, PrdSystemWorkTypeRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

