/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.work.service;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentHistoryPayload;
import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentHistoryQuery;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.work.service.PrdWorkAssignmentHistoryService;
import com.elitesland.tw.tw5.api.prd.work.service.PrdWorkAssignmentService;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.work.convert.PrdWorkAssignmentConvert;
import com.elitesland.tw.tw5.server.prd.work.dao.PrdWorkAssignmentDAO;
import com.elitesland.tw.tw5.server.prd.work.entity.PrdWorkAssignmentDO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdWorkAssignmentServiceImpl
extends BaseServiceImpl
implements PrdWorkAssignmentService {
    private static final Logger log = LoggerFactory.getLogger(PrdWorkAssignmentServiceImpl.class);
    private final PrdWorkAssignmentDAO dao;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdWorkAssignmentHistoryService historyService;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;

    @Transactional
    public PrdWorkAssignmentVO insert(PrdWorkAssignmentPayload payload) {
        payload.setAssignmentStatus("create");
        payload.setAssignmentNo(this.generateSeqNum("AS", new String[0]));
        PrdWorkAssignmentDO ado = PrdWorkAssignmentConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
        historyPayload.setAssignmentId(ado.getId());
        historyPayload.setOperationTitle("\u7531" + current.getLastName() + "\u521b\u5efa\u3002");
        this.historyService.insert(historyPayload);
        return PrdWorkAssignmentConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long updateByKeyDynamic(PrdWorkAssignmentPayload payload) {
        PrdWorkAssignmentVO oldWorkAssignment = this.queryByKey(payload.getId());
        PrdWorkAssignmentVO newWorkAssignment = PrdWorkAssignmentConvert.INSTANCE.toVo(payload);
        this.transaction(Collections.singletonList(newWorkAssignment));
        PrdWorkAssignmentHistoryPayload historyPayload = this.getUpdateHistory(oldWorkAssignment, newWorkAssignment);
        long result = this.dao.updateByKeyDynamic(payload);
        this.historyService.insert(historyPayload);
        return result;
    }

    private PrdWorkAssignmentHistoryPayload getUpdateHistory(PrdWorkAssignmentVO oldWorkAssignment, PrdWorkAssignmentVO newWorkAssignment) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
        historyPayload.setAssignmentId(oldWorkAssignment.getId());
        StringBuilder sb = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getAssignmentName())) {
            String oldAssignmentName = StringUtils.hasText((String)oldWorkAssignment.getAssignmentName()) ? oldWorkAssignment.getAssignmentName() : "";
            sb.append("\u4fee\u6539\u4e86\u540d\u79f0\uff0c\u65e7\u503c\u4e3a\u201d" + oldAssignmentName + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getAssignmentName() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getPriority())) {
            String oldPriorityDesc = StringUtils.hasText((String)oldWorkAssignment.getPriorityDesc()) ? oldWorkAssignment.getPriorityDesc() : "";
            sb.append("\u4fee\u6539\u4e86\u4f18\u5148\u7ea7\uff0c\u65e7\u503c\u4e3a\u201d" + oldPriorityDesc + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getPriorityDesc() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getAssignUserId())) {
            String oldAssignUserIdDesc = StringUtils.hasText((String)oldWorkAssignment.getAssignUserIdDesc()) ? oldWorkAssignment.getAssignUserIdDesc() : "";
            sb.append("\u4fee\u6539\u4e86\u6307\u6d3e\u4eba\uff0c\u65e7\u503c\u4e3a\u201d" + oldAssignUserIdDesc + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getAssignUserIdDesc() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getAssistUserIds())) {
            String oldAssistUserIdsDesc = StringUtils.hasText((String)oldWorkAssignment.getAssistUserIdsDesc()) ? oldWorkAssignment.getAssistUserIdsDesc() : "";
            sb.append("\u4fee\u6539\u4e86\u534f\u52a9\u4eba\uff0c\u65e7\u503c\u4e3a\u201d" + oldAssistUserIdsDesc + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getAssistUserIdsDesc() + "\u201d;");
        }
        if (StringUtils.hasText((String)newWorkAssignment.getAssignmentType())) {
            String oldAssignmentTypeDesc = StringUtils.hasText((String)oldWorkAssignment.getAssignmentTypeDesc()) ? oldWorkAssignment.getAssignmentTypeDesc() : "";
            sb.append("\u4fee\u6539\u4e86\u7c7b\u578b\uff0c\u65e7\u503c\u4e3a\u201d" + oldAssignmentTypeDesc + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getAssignmentTypeDesc() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getStartDate())) {
            String oldStartDate = ObjectUtils.isEmpty((Object)oldWorkAssignment.getStartDate()) ? "" : oldWorkAssignment.getStartDate().toString();
            sb.append("\u4fee\u6539\u4e86\u5f00\u59cb\u65f6\u95f4\uff0c\u65e7\u503c\u4e3a\u201d" + oldStartDate + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getStartDate() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getFinishDate())) {
            String oldFinishDate = ObjectUtils.isEmpty((Object)oldWorkAssignment.getFinishDate()) ? "" : oldWorkAssignment.getFinishDate().toString();
            sb.append("\u4fee\u6539\u4e86\u5b8c\u6210\u65f6\u95f4\uff0c\u65e7\u503c\u4e3a\u201d" + oldFinishDate + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getFinishDate() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getActualStartDate())) {
            String oldActualStartDate = ObjectUtils.isEmpty((Object)oldWorkAssignment.getActualStartDate()) ? "" : oldWorkAssignment.getActualStartDate().toString();
            sb.append("\u4fee\u6539\u4e86\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\uff0c\u65e7\u503c\u4e3a\u201d" + oldActualStartDate + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getActualStartDate() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getAssignmentStatus())) {
            sb.append("\u4fee\u6539\u4e86\u72b6\u6001\uff0c\u65e7\u503c\u4e3a\u201d" + oldWorkAssignment.getAssignmentStatusDesc() + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getAssignmentStatusDesc() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getActualFinishDate())) {
            String oldActualFinishDate = ObjectUtils.isEmpty((Object)oldWorkAssignment.getActualFinishDate()) ? "" : oldWorkAssignment.getActualFinishDate().toString();
            sb.append("\u4fee\u6539\u4e86\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4\uff0c\u65e7\u503c\u4e3a\u201d" + oldActualFinishDate + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getActualFinishDate() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getFinishUserId())) {
            String oldFinishUserIdDesc = StringUtils.hasText((String)oldWorkAssignment.getFinishUserIdDesc()) ? oldWorkAssignment.getFinishUserIdDesc() : "";
            sb.append("\u4fee\u6539\u4e86\u5b8c\u6210\u4eba\uff0c\u65e7\u503c\u4e3a\u201d" + oldFinishUserIdDesc + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getFinishUserIdDesc() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getProgress())) {
            String oldProgressDesc = ObjectUtils.isEmpty((Object)oldWorkAssignment.getProgress()) ? "" : oldWorkAssignment.getProgress().toString();
            sb.append("\u4fee\u6539\u4e86\u8fdb\u5ea6\uff0c\u65e7\u503c\u4e3a\u201d" + oldProgressDesc + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getProgress() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getAssignmentDesc())) {
            String oldAssignmentDesc = ObjectUtils.isEmpty((Object)oldWorkAssignment.getAssignmentDesc()) ? "" : oldWorkAssignment.getAssignmentDesc();
            sb.append("\u4fee\u6539\u4e86\u4efb\u52a1\u63cf\u8ff0\uff0c\u65e7\u503c\u4e3a\u201d" + oldAssignmentDesc + "\u201d\uff0c\u65b0\u503c\u4e3a\u201c" + newWorkAssignment.getAssignmentDesc() + "\u201d;");
        }
        if (!ObjectUtils.isEmpty((Object)newWorkAssignment.getFileCodes())) {
            sb.append("\u4fee\u6539\u4e86\u9644\u4ef6;");
        }
        if (StringUtils.hasText((String)String.valueOf(sb))) {
            historyPayload.setOperationTitle("\u7531" + current.getLastName() + "\u7f16\u8f91\u3002");
            historyPayload.setRemark(String.valueOf(sb));
        }
        return historyPayload;
    }

    public PagingVO<PrdWorkAssignmentVO> paging(PrdWorkAssignmentQuery query) {
        PagingVO<PrdWorkAssignmentVO> pagingVO = this.dao.queryPaging(query);
        List assignmentVOS = pagingVO.getRecords();
        this.transaction(assignmentVOS);
        return pagingVO;
    }

    public PrdWorkAssignmentVO queryByKey(Long key) {
        PrdWorkAssignmentVO prdWorkAssignmentVO = this.dao.queryByKey(key);
        PrdWorkAssignmentHistoryQuery query = new PrdWorkAssignmentHistoryQuery();
        query.setAssignmentId(key);
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("createTime");
        orderItem.setAsc(true);
        query.setOrders(Collections.singletonList(orderItem));
        List historyVOS = this.historyService.queryList(query);
        prdWorkAssignmentVO.setAssignmentHistoryList(historyVOS);
        this.transaction(Collections.singletonList(prdWorkAssignmentVO));
        prdWorkAssignmentVO.setFileDatas(this.fileUtil.getFileDatas(prdWorkAssignmentVO.getFileCodes()));
        return prdWorkAssignmentVO;
    }

    @Transactional
    public Boolean pending(List<Long> keys) {
        this.dao.updateAssignmentStatusByIds(keys, "pending");
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        ArrayList<PrdWorkAssignmentHistoryPayload> saveHistoryList = new ArrayList<PrdWorkAssignmentHistoryPayload>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("\u7531" + current.getLastName() + "\u6682\u6302\u3002");
            saveHistoryList.add(historyPayload);
        }
        this.historyService.insertAll(saveHistoryList);
        return true;
    }

    @Transactional
    public Boolean start(List<Long> keys) {
        this.dao.updateAssignmentStatusByIds(keys, "execution");
        this.dao.updateActualStartDateByIds(keys, LocalDate.now());
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        ArrayList<PrdWorkAssignmentHistoryPayload> saveHistoryList = new ArrayList<PrdWorkAssignmentHistoryPayload>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("\u7531" + current.getLastName() + "\u542f\u52a8\u3002");
            saveHistoryList.add(historyPayload);
        }
        this.historyService.insertAll(saveHistoryList);
        return true;
    }

    @Transactional
    public Boolean finish(List<Long> keys) {
        this.dao.updateAssignmentStatusByIds(keys, "finish");
        this.dao.updateActualFinishDateByIds(keys, LocalDate.now());
        this.dao.updateProgressByIds(keys, 100);
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        ArrayList<PrdWorkAssignmentHistoryPayload> saveHistoryList = new ArrayList<PrdWorkAssignmentHistoryPayload>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("\u7531" + current.getLastName() + "\u5b8c\u6210\u3002");
            saveHistoryList.add(historyPayload);
        }
        this.historyService.insertAll(saveHistoryList);
        return true;
    }

    @Transactional
    public Boolean close(List<Long> keys) {
        this.dao.updateAssignmentStatusByIds(keys, "close");
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        ArrayList<PrdWorkAssignmentHistoryPayload> saveHistoryList = new ArrayList<PrdWorkAssignmentHistoryPayload>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("\u7531" + current.getLastName() + "\u5173\u95ed\u3002");
            saveHistoryList.add(historyPayload);
        }
        this.historyService.insertAll(saveHistoryList);
        return true;
    }

    public List<PrdWorkAssignmentVO> queryList(PrdWorkAssignmentQuery query) {
        List<PrdWorkAssignmentVO> voList = this.dao.queryListDynamic(query);
        this.transaction(voList);
        return voList;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
        return true;
    }

    private void transaction(List<PrdWorkAssignmentVO> list) {
        ArrayList<Long> userIdList = new ArrayList<Long>();
        list.stream().forEach(e -> {
            if (!ObjectUtils.isEmpty((Object)e.getFinishUserId())) {
                userIdList.add(e.getFinishUserId());
            }
            if (!ObjectUtils.isEmpty((Object)e.getAssignUserId())) {
                userIdList.add(e.getAssignUserId());
            }
            if (StringUtils.hasText((String)e.getAssistUserIds())) {
                String[] assistUserIdsSplit;
                for (String userId : assistUserIdsSplit = e.getAssistUserIds().split(",")) {
                    userIdList.add(Long.valueOf(userId));
                }
            }
            e.setCreateUserName(this.cacheUtil.getUserName(e.getCreateUserId()));
        });
        List<PrdOrgEmployeeVO> employeeVOS = this.employeeDAO.queryList(userIdList);
        Map sysUserVOMap = employeeVOS.stream().collect(Collectors.toMap(PrdOrgEmployeeVO::getUserId, Function.identity()));
        for (PrdWorkAssignmentVO vo : list) {
            String assistUserIds;
            PrdOrgEmployeeVO sysUser;
            vo.setAssignmentStatusDesc(this.cacheUtil.transferSystemSelection("work:assignment:assignment_status", vo.getAssignmentStatus()));
            vo.setPriorityDesc(this.cacheUtil.transferSystemSelection("work:assignment:priority", vo.getPriority()));
            vo.setAssignmentTypeDesc(this.cacheUtil.transferSystemSelection("work:assignment:assignment_type", vo.getAssignmentType()));
            if (!ObjectUtils.isEmpty((Object)vo.getFinishUserId()) && !ObjectUtils.isEmpty((Object)(sysUser = (PrdOrgEmployeeVO)sysUserVOMap.get(vo.getFinishUserId())))) {
                vo.setFinishUserIdDesc(sysUser.getEmployeeName());
            }
            if (!ObjectUtils.isEmpty((Object)vo.getAssignUserId()) && !ObjectUtils.isEmpty((Object)(sysUser = (PrdOrgEmployeeVO)sysUserVOMap.get(vo.getAssignUserId())))) {
                vo.setAssignUserIdDesc(sysUser.getEmployeeName());
            }
            if (!StringUtils.hasText((String)(assistUserIds = vo.getAssistUserIds()))) continue;
            String[] assistUserIdsSplit = assistUserIds.split(",");
            HashSet<String> assistUserIdsDesc = new HashSet<String>();
            for (String userId : assistUserIdsSplit) {
                PrdOrgEmployeeVO sysUser2 = (PrdOrgEmployeeVO)sysUserVOMap.get(Long.valueOf(userId));
                if (ObjectUtils.isEmpty((Object)sysUser2)) continue;
                assistUserIdsDesc.add(sysUser2.getEmployeeName());
            }
            vo.setAssistUserIdsDesc(String.join((CharSequence)",", assistUserIdsDesc));
        }
    }

    public PrdWorkAssignmentServiceImpl(PrdWorkAssignmentDAO dao, PrdOrgEmployeeDAO employeeDAO, PrdWorkAssignmentHistoryService historyService, CacheUtil cacheUtil, FileUtil fileUtil) {
        this.dao = dao;
        this.employeeDAO = employeeDAO;
        this.historyService = historyService;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
    }
}

