package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_user_message", indexes = {@Index(name = "user_index", columnList = "user_id"), @Index(name = "message_index", columnList = "message_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_user_message", comment = "用户消息表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdUserMessageDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("用户ID")
    @Column(name = "user_id")
    private Long userId;

    @Comment("消息id")
    @Column(name = "message_id")
    private Long messageId;

    @Comment("消息标题")
    @Column()
    private String messageTitle;

    @Comment("消息内容")
    @Column()
    private String messageContent;

    @Comment("消息类型")
    @Column()
    private String contentType;

    @Comment("消息大类")
    @Column()
    private String contentBigType;

    /**
     * 发布来源具体对象， （以谁的名义发布该条消息，个人，系统，组织，角色等，默认是个人）
     */
    @Comment("发布来源")
    @Column()
    private String createSource;

    @Comment("消息标签")
    @Column()
    private String messageTag;

    @Comment("通知范围")
    @Column()
    private String noticeScope;

    @Comment("通知资源")
    @Column()
    private String noticeSource;

    @Comment("消息状态")
    @Column()
    private Integer messageStatus = 0;

    @Comment("消息标签排序")
    @Column()
    private Integer sortIndex = 0;

}
