package com.elitesland.tw.tw5.server.prd.work.controller;

import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentHistoryPayload;
import com.elitesland.tw.tw5.api.prd.work.service.PrdWorkAssignmentHistoryService;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentHistoryVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api("系统功能处理-指派")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/work")
@Slf4j
public class PrdWorkAssignmentHistoryController {
    private final PrdWorkAssignmentHistoryService service;
    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/assignmentHistory/insert")
    public TwOutputUtil insert(PrdWorkAssignmentHistoryPayload payload) {
        PrdWorkAssignmentHistoryVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/assignmentHistory/update")
    public TwOutputUtil update(PrdWorkAssignmentHistoryPayload payload) {
        PrdWorkAssignmentHistoryVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }
}
