/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.PrdUserMessageQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserMessageService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageTypeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserMessageDAO;
import com.elitesland.tw.tw5.server.prd.system.service.PrdMessageConfigServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdUserMessageServiceImpl
implements PrdUserMessageService {
    private static final Logger log = LoggerFactory.getLogger(PrdUserMessageServiceImpl.class);
    private final PrdUserMessageDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigServiceImpl service;

    public Long queryTotal() {
        return this.dao.queryTotal(GlobalUtil.getLoginUserId());
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys, GlobalUtil.getLoginUserId());
        return true;
    }

    @Transactional
    public PrdUserMessageVO queryByKey(Long key) {
        PrdUserMessageVO messageVO = this.dao.queryByKey(key);
        this.transferSystemSelection(messageVO);
        String name = this.service.getNoticeSourceName(messageVO.getMessageId(), messageVO.getNoticeScope(), messageVO.getNoticeSource());
        messageVO.setNoticeSourceName(name);
        if (messageVO.getMessageStatus() == 0) {
            ArrayList<Long> keys = new ArrayList<Long>();
            keys.add(key);
            this.dao.updateStatus(keys, GlobalUtil.getLoginUserId());
        }
        return messageVO;
    }

    public PagingVO<PrdUserMessageVO> paging(PrdUserMessageQuery query) {
        PagingVO<PrdUserMessageVO> messageVOPagingVO = this.dao.queryPaging(query, GlobalUtil.getLoginUserId());
        List configVOS = messageVOPagingVO.getRecords();
        configVOS.forEach(configVO -> this.transferSystemSelection((PrdUserMessageVO)configVO));
        return messageVOPagingVO;
    }

    @Transactional
    public boolean onKeyUpdateStatus(List<Long> keys) {
        this.dao.updateStatus(keys, GlobalUtil.getLoginUserId());
        return true;
    }

    public List<PrdUserMessageTypeVO> findUnreadMessageTypeList() {
        List<PrdUserMessageTypeVO> messageTypeList = this.dao.findMessageTypeList();
        List<PrdUserMessageTypeVO> unreadMessageTypeList = this.dao.findUnreadMessageTypeList();
        List<PrdUserMessageVO> lastUserMessageList = this.dao.findLastUserMessage();
        unreadMessageTypeList.forEach(unreadMessageType -> lastUserMessageList.stream().filter(prdUserMessageVO -> unreadMessageType.getContentType().equals(prdUserMessageVO.getContentType())).findFirst().ifPresent(arg_0 -> ((PrdUserMessageTypeVO)unreadMessageType).setLastUserMessageVO(arg_0)));
        messageTypeList.forEach(messageType -> unreadMessageTypeList.stream().filter(unreadMessageType -> messageType.getContentType().equals(unreadMessageType.getContentType())).findFirst().ifPresent(unreadMessageType -> messageType.setUnreadContentCount(unreadMessageType.getUnreadContentCount())));
        return messageTypeList;
    }

    public List<PrdUserMessageVO> findUnreadMessageListByType(String contentType) {
        List<PrdUserMessageVO> unreadMessageListByType = this.dao.findUnreadMessageListByType(contentType);
        unreadMessageListByType.forEach(prdUserMessageVO -> this.transferSystemSelection((PrdUserMessageVO)prdUserMessageVO));
        return unreadMessageListByType;
    }

    void transferSystemSelection(PrdUserMessageVO vo) {
        vo.setContentTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentType.getCode(), vo.getContentType()));
        vo.setContentBigTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentBigType.getCode(), vo.getContentBigType()));
        vo.setMessageTagName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.MessageTag.getCode(), vo.getMessageTag()));
        vo.setNoticeScopeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.NoticeScope.getCode(), vo.getNoticeScope()));
    }

    public PrdUserMessageServiceImpl(PrdUserMessageDAO dao, CacheUtil cacheUtil, PrdMessageConfigServiceImpl service) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
        this.service = service;
    }
}

