package com.elitesland.tw.tw5.server.log.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogChannelEnum;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.persistence.*;
import java.io.Serial;


/**
 * 接口请求日志记录
 *
 * @author duwh
 * @date 2022/11/09
 */
@Entity
@Table(name = "api_request_log")
@org.hibernate.annotations.Table(appliesTo = "api_request_log", comment = "接口请求日志记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ApiRequestLogDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 1637797106241809746L;
    /**
     * 类型
     * 新增接口，需要维护
     */
    @Comment("类型")
    @Column()
    @Enumerated(EnumType.STRING)
    private ApiRequestLogTypeEnum type;

    @Comment("调入or调出")
    @Column()
    @Enumerated(EnumType.STRING)
    private ApiRequestLogChannelEnum channel;

    @Comment("uri")
    @Column()
    private String uri;

    @Comment("请求方式")
    @Column()
    @Enumerated(EnumType.STRING)
    private RequestMethod requestMethod;

    @Comment("请求参数")
    @Column(length = 3000)
    private String param;

    @Comment("请求头")
    @Column()
    private String header;

    @Comment("返回结果")
    @Column(length = 5000)
    private String result;

    @Comment("状态")
    @Column()
    private String status;

    @Comment("耗时")
    @Column()
    private Long time;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    public ApiRequestLogDO() {
    }

    public ApiRequestLogDO(ApiRequestLogTypeEnum type, ApiRequestLogChannelEnum channel, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark) {
        this.type = type;
        this.channel = channel;
        this.uri = uri;
        this.requestMethod = requestMethod;
        this.param = param;
        this.header = header;
        this.result = result;
        this.status = status;
    }

    public ApiRequestLogDO(ApiRequestLogTypeEnum type, ApiRequestLogChannelEnum channel, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark, String ext1, String ext2, String ext3, String ext4) {
        this.type = type;
        this.channel = channel;
        this.uri = uri;
        this.requestMethod = requestMethod;
        this.param = param;
        this.header = header;
        this.result = result;
        this.status = status;
        this.ext1 = ext1;
        this.ext2 = ext2;
        this.ext3 = ext3;
        this.ext4 = ext4;
    }
}
