package com.elitesland.tw.tw5.server.prd.ab.dao;


import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbOrCompanyPayload;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbPayload;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbAddressRepo;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgCompanyRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class PrdAbDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbRepo repo;
    private final PrdAbAddressRepo repoAddress;
    private final PrdOrgCompanyRepo repoCompany;
    private final QPrdAbDO qdo = QPrdAbDO.prdAbDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdAbAddressDO qdoAddress = QPrdAbAddressDO.prdAbAddressDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdAbDO save(PrdAbDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgCompanyDO saveCompany(PrdOrgCompanyDO ado) {
        return repoCompany.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdAbAddressDO saveAddress(PrdAbAddressDO ado) {
        return repoAddress.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdAbVO> getJpaQuerySelect() {
        JPAQuery<PrdAbVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdAbVO.class,
                qdo.id,
                qdo.bookNo,
                qdo.bookType,
                qdo.relateType,
                qdo.bookName,
                qdoCompany.id.as("companyId"),
                qdoCompany.companyAddress,
                qdoCompany.longitudeLatitude,
                qdoCompany.taxNo
        )).from(qdo).leftJoin(qdoCompany).on(qdoCompany.bookId.longValue().eq(qdo.id.longValue()));
        return jpaQuery;
    }

    public PrdAbVO queryCompanyByTaxNo(String taxNo) {
        JPAQuery<PrdAbVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdoCompany.taxNo.eq(taxNo));
        jpaQuery.where(qdo.deleteFlag.eq(0)).where(qdoCompany.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public PrdAbVO queryCompanyByBookId(Long bookId) {
        JPAQuery<PrdAbVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdoCompany.bookId.eq(bookId));
        jpaQuery.where(qdo.deleteFlag.eq(0)).where(qdoCompany.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdAbPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getBookName() != null) {
            update.set(qdo.bookName, payload.getBookName());
        }
        if (payload.getBookType() != null) {
            update.set(qdo.bookType, payload.getBookType());
        }
        if (payload.getRelateType() != null) {
            update.set(qdo.relateType, payload.getRelateType());
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 修改公司信息
     *
     * @param companyDO 要修改的对象
     * @return 修改的行数
     */
    public long updateCompanyByKey(PrdAbOrCompanyPayload companyDO) {
        boolean isUp = false;
        JPAUpdateClause update = jpaQueryFactory.update(qdoCompany)
                .where(qdoCompany.bookId.eq(companyDO.getId()));

        if (companyDO.getCompanyName() != null) {
            isUp = true;
            update.set(qdoCompany.companyName, companyDO.getCompanyName());
        }
        if (companyDO.getCompanyIndustry() != null) {
            isUp = true;
            update.set(qdoCompany.companyIndustry, companyDO.getCompanyIndustry());
        }
        if (companyDO.getTaxNo() != null) {
            isUp = true;
            update.set(qdoCompany.taxNo, companyDO.getTaxNo());
        }
        if (companyDO.getCompanyPhone() != null) {
            isUp = true;
            update.set(qdoCompany.companyPhone, companyDO.getCompanyPhone());
        }
        if (companyDO.getCompanyEmail() != null) {
            isUp = true;
            update.set(qdoCompany.companyEmail, companyDO.getCompanyEmail());
        }
        if (companyDO.getCompanyFax() != null) {
            isUp = true;
            update.set(qdoCompany.companyFax, companyDO.getCompanyFax());
        }
        if (companyDO.getProvince() != null) {
            isUp = true;
            update.set(qdoCompany.province, companyDO.getProvince());
        }
        if (companyDO.getProvinceName() != null) {
            isUp = true;
            update.set(qdoCompany.provinceName, companyDO.getProvinceName());
        }
        if (companyDO.getLongitudeLatitude() != null) {
            isUp = true;
            update.set(qdoCompany.longitudeLatitude, companyDO.getLongitudeLatitude());
        }
        if (companyDO.getCity() != null) {
            isUp = true;
            update.set(qdoCompany.city, companyDO.getCity());
        }
        if (companyDO.getCityName() != null) {
            isUp = true;
            update.set(qdoCompany.cityName, companyDO.getCityName());
        }
        if (companyDO.getDistrict() != null) {
            isUp = true;
            update.set(qdoCompany.district, companyDO.getDistrict());
        }
        if (companyDO.getDistrictName() != null) {
            isUp = true;
            update.set(qdoCompany.districtName, companyDO.getDistrictName());
        }
        if (companyDO.getCompanyAddress() != null) {
            isUp = true;
            update.set(qdoCompany.companyAddress, companyDO.getCompanyAddress());
        }
        if (companyDO.getCompanyWebsite() != null) {
            isUp = true;
            update.set(qdoCompany.companyWebsite, companyDO.getCompanyWebsite());
        }
        if (companyDO.getCompanyScale() != null) {
            isUp = true;
            update.set(qdoCompany.companyScale, companyDO.getCompanyScale());
        }
        if (companyDO.getCurrency() != null) {
            isUp = true;
            update.set(qdoCompany.currency, companyDO.getCurrency());
        }
        if (companyDO.getLanguage() != null) {
            isUp = true;
            update.set(qdoCompany.language, companyDO.getLanguage());
        }
        if (companyDO.getCompanyNature() != null) {
            isUp = true;
            update.set(qdoCompany.companyNature, companyDO.getCompanyNature());
        }
        if (!isUp) {
            return 0L;
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 修改公司省市区，需要清空值，所以单独处理
     *
     * @return 修改的行数
     */
    public long setProvinceCityDistrictForCompany(PrdAbOrCompanyPayload payload) {
        return jpaQueryFactory.update(qdoCompany)
                .set(qdoCompany.province, payload.getProvince())
                .set(qdoCompany.provinceName, payload.getProvinceName())
                .set(qdoCompany.city, payload.getCity())
                .set(qdoCompany.cityName, payload.getCityName())
                .set(qdoCompany.district, payload.getDistrict())
                .set(qdoCompany.districtName, payload.getDistrictName())
                .where(qdoCompany.bookId.eq(payload.getId()))
                .execute();
    }

    public Long getIdByV4(Long bookIdV4) {
        return repo.getIdByV4(bookIdV4);
    }
}
