package com.elitesland.tw.tw5.server.prd.qixin.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 启信宝配置属性
 *
 * @author duwh
 * @date 2022/11/22
 */
@Data
@ConfigurationProperties("qixin")
public class QiXinProperties {

    private Boolean enabled = false;

    /**
     * 缓存天数
     */
    private Integer cacheDay = 30;

    /**
     * appkey
     * 测试：710322a1-590f-4826-8f65-9f3091e84da2
     * 生产：
     */
    private String appkey = "710322a1-590f-4826-8f65-9f3091e84da2";

    /**
     * secretKey
     * 测试：5bac81a5-044e-4fee-b91b-b5db71870365
     */
    private String secretKey = "5bac81a5-044e-4fee-b91b-b5db71870365";

    /**
     * 域名
     */
    private String domain = "https://api.qixin.com";

    /**
     * 1.31 模糊搜索
     */
    private String uriSearch = "/APIService/v2/search/advSearch";
    /**
     * 1.2 高级搜索
     */
    private String uriAdvanceSearchNew = "/APIService/search/advanceSearchNew";
    /**
     * 1.51 企业联系方式
     */
    private String uriGetContactInfo = "/APIService/enterprise/getContactInfo";
    /**
     * 10.1 新闻列表
     * 企业新闻列表，包括新闻来源、情感属性、舆情标签、负面指数等
     * 申请接口
     * 单价：0.1元/次
     */
    private String uriGetNewsListByName = "/APIService/v2/news/getNewsListByName";
    /**
     * 1.41 工商照面
     * 企业工商照面及相关信息，包括统一社会信用代码、注册资本、经营范围、企业法定代表人等
     * 申请接口
     * 单价：0.1元/次
     * <p>
     * https://data.qixin.com/api-detail?categoryId=27C4602EBB38429EK08QR7fy&apiId=1.41
     */
    private String getBasicInfoUri = "/APIService/enterprise/getBasicInfo";
    /**
     * 1.17 企业LOGO
     * <p>
     * 单价：0.1元/次
     */
    private String getEntLogoByNameUri = "/APIService/enterprise/getEntLogoByName";
    /**
     * 1.16 企业简介
     * 企业简介信息
     * <p>
     * 单价：0.1元/次
     */
    private String getEntBriefByNameUri = "/APIService/enterprise/getEntBriefByName";
    /**
     * 1.53 企业年报网址
     * 企业年报网址信息，包括网站名称、网址、网址类型、网址来源、审核时间等
     * <p>
     * 单价：0.1元/次
     */
    private String getWebsitesUri = "/APIService/enterprise/getWebsites";
    /**
     * 1.43 工商股东
     * 企业工商股东信息(不包含企业自行公示和年报股东)
     * <p>
     * 单价：0.1元/次
     */
    private String getPartnersUri = "/APIService/enterprise/getPartners";
    /**
     * 1.45 主要人员
     * 企业工商主要人员信息，包括主要人员姓名及职位
     * <p>
     * 单价：0.1元/次
     */
    private String getEmployeesUri = "/APIService/enterprise/getEmployees";


    public String getUriSearch() {
        return domain + uriSearch;
    }

    public String getUriGetContactInfo() {
        return domain + uriGetContactInfo;
    }

    public String getUriAdvanceSearchNew() {
        return domain + uriAdvanceSearchNew;
    }

    public String getUriGetNewsListByName() {
        return domain + uriGetNewsListByName;
    }

    public String getGetBasicInfoUri() {
        return domain + getBasicInfoUri;
    }

    public String getGetEntLogoByNameUri() {
        return domain + getEntLogoByNameUri;
    }

    public String getGetEntBriefByNameUri() {
        return domain + getEntBriefByNameUri;
    }

    public String getGetWebsitesUri() {
        return domain + getWebsitesUri;
    }

    public String getGetPartnersUri() {
        return domain + getPartnersUri;
    }

    public String getGetEmployeesUri() {
        return domain + getEmployeesUri;
    }
}
