package com.elitesland.tw.tw5.server.prd.schedule.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author zoey
 * @Description:日程表
 * @date 2022/4/19 - 15:12
 */
@Entity
@Table(name = "prd_schedule", indexes = {@Index(name = "cal_index", columnList = "cal_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_schedule", comment = "日程表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdScheduleDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("日程标题")
    @Column(name = "title")
    private String title;

    @Comment("日程描述")
    private String description;

    @Comment("日程地址")
    private String location;

    @Comment("全天")
    private Integer allDay;

    @Comment("开始时间")
    @Column(nullable = false)
    private LocalDateTime startTime;

    @Comment("结束时间")
    private LocalDateTime endTime;

    @Comment("日历id")
    @Column(name = "cal_id")
    private Long calId;

    @Comment("是否允许非参与人主动加入日程")
    @Column(name = "allow_active_join")
    private Integer allowActiveJoin = 0;

    @Comment("是否重复")
    @Column(name = "is_repeat" )
    private Integer isRepeat;

    @Comment("是否提醒")
    @Column(name = "is_remind")
    private Integer isRemind;

    @Comment("提前发送提醒时间")
    @Column(name = "remind_before_event_secs")
    private Integer remindBeforeEventSecs;

    @Comment("企业微信主键")
    private String qyWxScheduleId;

}
