/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.change.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangeDataPayload;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.convert.ComChangeConvert;
import com.elitesland.tw.tw5.server.common.change.dao.ComChangeDAO;
import com.elitesland.tw.tw5.server.common.change.entity.ComChangeDO;
import com.elitesland.tw.tw5.server.common.change.repo.ComChangeRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ComChangeServiceImpl
implements ComChangeService {
    private static final Logger log = LoggerFactory.getLogger(ComChangeServiceImpl.class);
    private final ComChangeRepo repo;
    private final ComChangeDAO dao;

    @Transactional(rollbackOn={Exception.class})
    public ComChangeVO insert(ComChangePayload payload) {
        Long count = this.repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, payload.getChangeType(), payload.getChangeDocId());
        int num = 1;
        if (!ObjectUtils.isEmpty((Object)count)) {
            num = count.intValue() + 1;
        }
        ComChangeDO comChangeDO = ComChangeConvert.INSTANCE.toDo(payload);
        comChangeDO.setVersionNo(num);
        ComChangeDO save = (ComChangeDO)this.repo.save(comChangeDO);
        return ComChangeConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackOn={Exception.class})
    public Long save(String changeType, Object originalModel, Object changeModel, String docId) {
        ComChangeDO originalDO;
        ComChangeDO save;
        String originalContent = JSONObject.toJSONString((Object)originalModel);
        log.info("originalContent = {}", (Object)originalContent);
        ComChangeDO v0 = this.repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId, 0);
        if (v0 == null && (save = (ComChangeDO)this.repo.save(originalDO = new ComChangeDO().setChangeType(changeType).setVersionNo(0).setChangeContent(originalContent).setChangeDocId(docId))) == null) {
            return -1L;
        }
        Long count = this.repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);
        String changeContent = JSONObject.toJSONString((Object)changeModel);
        log.info("changeContent = {}", (Object)changeContent);
        ComChangeDO changeDO = new ComChangeDO().setChangeType(changeType).setVersionNo(count.intValue()).setChangeContent(changeContent).setChangeDocId(docId);
        ComChangeDO changeSave = (ComChangeDO)this.repo.save(changeDO);
        if (changeSave == null) {
            return -1L;
        }
        return changeSave.getId();
    }

    public Long save(ComChangeDataPayload changeDataPayload) {
        ComChangeDO originalDO;
        ComChangeDO save;
        String changeType = changeDataPayload.getChangeType();
        String docId = changeDataPayload.getChangeDocId();
        String originalContent = JSONObject.toJSONString((Object)changeDataPayload.getOriginalModel());
        ComChangeDO v0 = this.repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, changeType, docId, 0);
        if (v0 == null && (save = (ComChangeDO)this.repo.save(originalDO = new ComChangeDO().setChangeType(changeType).setVersionNo(0).setChangeContent(originalContent).setChangeDocId(docId))) == null) {
            return -1L;
        }
        Long count = this.repo.countByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);
        String changeContent = JSONObject.toJSONString((Object)changeDataPayload.getChangeModel());
        ComChangeDO changeDO = new ComChangeDO().setChangeType(changeType).setVersionNo(count.intValue()).setChangeContent(changeContent).setChangeDocId(docId).setExtString1(changeDataPayload.getExtString1()).setExtString2(changeDataPayload.getExtString2()).setExtString3(changeDataPayload.getExtString3()).setExtString4(changeDataPayload.getExtString4()).setExtString5(changeDataPayload.getExtString5());
        ComChangeDO changeSave = (ComChangeDO)this.repo.save(changeDO);
        if (changeSave == null) {
            return -1L;
        }
        return changeSave.getId();
    }

    @Transactional(rollbackOn={Exception.class})
    public Long update(String changeType, String docId, Object changeModel) {
        List<ComChangeDO> dos = this.repo.findByDeleteFlagAndChangeTypeAndChangeDocId(0, changeType, docId);
        if (!ObjectUtils.isEmpty(dos)) {
            throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        ComChangeDO changeDO = null;
        Integer versionNo = 0;
        for (ComChangeDO businessChange : dos) {
            if (businessChange.getVersionNo() <= versionNo) continue;
            versionNo = businessChange.getVersionNo();
            changeDO = businessChange;
        }
        String changeContent = JSONObject.toJSONString((Object)changeModel);
        changeDO.setChangeContent(changeContent);
        this.repo.save(changeDO);
        return changeDO.getId();
    }

    public List<ComChangeVO> changeSearch(ComChangeQuery query) {
        List<ComChangeVO> comChangeVOS = this.dao.queryListDynamic(query);
        return comChangeVOS;
    }

    public Object getCompareChange(Long id, Long compareId) {
        ComChangeVO vo = this.dao.queryByKey(id);
        if (vo.getVersionNo() == 0) {
            return vo;
        }
        ComChangeVO vo1 = null;
        if (compareId == null) {
            ComChangeDO changeDO = this.repo.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(0, vo.getChangeType(), vo.getChangeDocId(), vo.getVersionNo() - 1);
            if (ObjectUtils.isEmpty((Object)changeDO)) {
                throw TwException.error("", "\u6bd4\u5bf9\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            vo1 = ComChangeConvert.INSTANCE.toVo(changeDO);
        } else {
            vo1 = this.dao.queryByKey(compareId);
        }
        if (vo1.getVersionNo() >= vo.getVersionNo()) {
            throw TwException.error("", "\u6bd4\u5bf9\u6570\u636e\u4ec5\u652f\u6301\u524d\u540e\u6bd4\u5bf9\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Map oldMap = (Map)JSON.parseObject((String)vo1.getChangeContent(), Map.class);
        Map newMap = (Map)JSON.parseObject((String)vo.getChangeContent(), Map.class);
        Map<String, Object> updateCompare = ComChangeServiceImpl.getUpdateCompare(oldMap, newMap);
        return updateCompare;
    }

    @Transactional(rollbackOn={Exception.class})
    public Long updateWorkFlow(ComChangePayload payload) {
        return this.dao.updateWorkFlow(payload);
    }

    public ComChangeVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public static Map<String, Object> getUpdateCompare(Map<String, Object> oldMap, Map<String, Object> newMap) {
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            if (oldMap.containsKey(entry.getKey())) continue;
            oldMap.put(entry.getKey(), null);
        }
        HashMap<String, Object> comparedMap = new HashMap<String, Object>();
        comparedMap.putAll(oldMap);
        for (Map.Entry<String, Object> entry : oldMap.entrySet()) {
            String oldKey = entry.getKey();
            Object oldValue = entry.getValue();
            Object newValue = newMap.get(oldKey);
            if (oldKey.toLowerCase().contains("status") || oldKey.toLowerCase().contains("createtime") || oldKey.toLowerCase().contains("creator")) continue;
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                if (ObjectUtils.isEmpty((Object)newValue)) continue;
                ComChangeServiceImpl.operateMap(comparedMap, oldKey, oldValue, newValue);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)newValue)) {
                comparedMap.put(oldKey + "_$$_new", "");
                continue;
            }
            if (ComChangeServiceImpl.checkEquals(oldValue.toString(), newValue.toString())) continue;
            ComChangeServiceImpl.operateMap(comparedMap, oldKey, oldValue, newValue);
        }
        return comparedMap;
    }

    static void operateMap(Map<String, Object> comparedMap, String key, Object oldValue, Object newValue) {
        if (newValue instanceof Map) {
            HashMap<String, Object> oldValue0 = new HashMap();
            if (!ObjectUtils.isEmpty((Object)oldValue)) {
                oldValue0 = (Map)oldValue;
            }
            Map newValue0 = (Map)newValue;
            Map<String, Object> comparedMap0 = ComChangeServiceImpl.getUpdateCompare(oldValue0, newValue0);
            comparedMap.put(key, comparedMap0);
        } else if (newValue instanceof List) {
            List oldValueList = new ArrayList();
            if (!ObjectUtils.isEmpty((Object)oldValue)) {
                oldValueList = (List)oldValue;
            }
            List newValueList = (List)newValue;
            ArrayList<Map> comparedList = new ArrayList<Map>();
            for (Map oldValue0 : oldValueList) {
                List collect = newValueList.stream().filter(newValue1 -> {
                    boolean isHave = true;
                    if (ObjectUtils.isEmpty(oldValue0.get("id"))) {
                        if (ObjectUtils.isEmpty(oldValue0.get("attrId"))) {
                            if (ObjectUtils.isEmpty(oldValue0.get("groupId"))) {
                                if (ObjectUtils.isEmpty(oldValue0.get("selectionValue"))) {
                                    return false;
                                }
                                isHave = oldValue0.get("selectionValue").toString().equals(newValue1.get("selectionValue").toString());
                            } else {
                                isHave = oldValue0.get("groupId").toString().equals(newValue1.get("groupId").toString());
                            }
                        } else {
                            isHave = oldValue0.get("attrId").toString().equals(newValue1.get("attrId").toString());
                        }
                    } else {
                        isHave = oldValue0.get("id").toString().equals(newValue1.get("id").toString());
                    }
                    return isHave;
                }).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect)) {
                    Map newValue0 = (Map)collect.get(0);
                    Map<String, Object> comparedMap0 = ComChangeServiceImpl.getUpdateCompare(oldValue0, newValue0);
                    comparedList.add(comparedMap0);
                    newValueList.remove(newValue0);
                    continue;
                }
                oldValue0.put("dataStatus", 1);
                comparedList.add(oldValue0);
            }
            for (Map newValue0 : newValueList) {
                newValue0.put("dataStatus", 2);
                comparedList.add(newValue0);
            }
            comparedMap.put(key, comparedList);
        } else {
            comparedMap.put(key + "_$$_new", newValue);
        }
    }

    private static boolean checkEquals(String value1, String value2) {
        if (ComChangeServiceImpl.isNumeric(value1) && ComChangeServiceImpl.isNumeric(value2)) {
            value1 = new BigDecimal(value1).stripTrailingZeros().toPlainString();
            value2 = new BigDecimal(value2).stripTrailingZeros().toPlainString();
        }
        return value1.equals(value2);
    }

    public static boolean isNumeric(String str) {
        if (null == str || "".equals(str) || str.contains("-")) {
            return false;
        }
        String regx = "[+-]*\\d+\\.?\\d*[Ee]*[+-]*\\d+";
        Pattern pattern = Pattern.compile(regx);
        boolean isNumber = pattern.matcher(str).matches();
        if (isNumber) {
            return isNumber;
        }
        regx = "^[-\\+]?[.\\d]*$";
        pattern = Pattern.compile(regx);
        return pattern.matcher(str).matches();
    }

    public ComChangeServiceImpl(ComChangeRepo repo, ComChangeDAO dao) {
        this.repo = repo;
        this.dao = dao;
    }
}

