/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.app.controller;

import com.elitesland.tw.tw5.api.prd.app.payload.AppVersionPayload;
import com.elitesland.tw.tw5.api.prd.app.query.AppVersionQuery;
import com.elitesland.tw.tw5.api.prd.app.service.AppVersionService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/app/appVersion"})
public class AppVersionController {
    private static final Logger log = LoggerFactory.getLogger(AppVersionController.class);
    private final AppVersionService appVersionService;

    @PostMapping
    public TwOutputUtil insert(@RequestBody AppVersionPayload payload) {
        GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.appVersionService.insert(payload));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody AppVersionPayload payload) {
        GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.appVersionService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.appVersionService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    public TwOutputUtil paging(AppVersionQuery query) {
        GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.appVersionService.paging(query));
    }

    @GetMapping(value={"/getCurrentVersion"})
    public TwOutputUtil getCurrentVersion() {
        GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.appVersionService.getCurrentVersion());
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        GlobalUtil.getLoginUserId();
        this.appVersionService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public AppVersionController(AppVersionService appVersionService) {
        this.appVersionService = appVersionService;
    }
}

