/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.qixin.service;

import cn.hutool.json.JSONUtil;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.qixin.config.QiXinProperties;
import com.elitesland.tw.tw5.server.prd.qixin.service.QiXinService;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class QiXinServiceImpl
implements QiXinService {
    private static final Logger log = LoggerFactory.getLogger(QiXinServiceImpl.class);
    private final ApiRequestLogService apiRequestLogService;
    private final QiXinProperties qiXinProperties;
    private final RedisUtils redisUtils;
    private static final String QXB_CACHE_KEY = "QXB_CACHE_KEY";

    @Override
    public String search(String matchType, String region, String keyword, String skip) {
        Object uriSearch = this.qiXinProperties.getUriSearch();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)matchType)) {
            urlParams.put("matchType", matchType);
        }
        if (StringUtils.hasText((String)region)) {
            urlParams.put("region", region);
        }
        if (StringUtils.hasText((String)keyword)) {
            urlParams.put("keyword", keyword);
        }
        if (StringUtils.hasText((String)skip)) {
            urlParams.put("skip", skip);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uriSearch = (String)uriSearch + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uriSearch);
        return result;
    }

    @Override
    public String advanceSearchNew(String keyword, String skip, String method, String org_type, String area_code, String industry_code, String econ_type, String capi_from, String capi_to, String date_from, String date_to, String status, String canbao_from, String canbao_to) {
        Object uri = this.qiXinProperties.getUriAdvanceSearchNew();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)keyword)) {
            urlParams.put("keyword", keyword);
        }
        if (StringUtils.hasText((String)skip)) {
            urlParams.put("skip", skip);
        }
        if (StringUtils.hasText((String)method)) {
            urlParams.put("method", method);
        }
        if (StringUtils.hasText((String)org_type)) {
            urlParams.put("org_type", org_type);
        }
        if (StringUtils.hasText((String)area_code)) {
            urlParams.put("area_code", area_code);
        }
        if (StringUtils.hasText((String)industry_code)) {
            urlParams.put("industry_code", industry_code);
        }
        if (StringUtils.hasText((String)econ_type)) {
            urlParams.put("econ_type", econ_type);
        }
        if (StringUtils.hasText((String)capi_from)) {
            urlParams.put("capi_from", capi_from);
        }
        if (StringUtils.hasText((String)capi_to)) {
            urlParams.put("capi_to", capi_to);
        }
        if (StringUtils.hasText((String)date_from)) {
            urlParams.put("date_from", date_from);
        }
        if (StringUtils.hasText((String)date_to)) {
            urlParams.put("date_to", date_to);
        }
        if (StringUtils.hasText((String)status)) {
            urlParams.put("status", status);
        }
        if (StringUtils.hasText((String)canbao_from)) {
            urlParams.put("canbao_from", canbao_from);
        }
        if (StringUtils.hasText((String)canbao_to)) {
            urlParams.put("canbao_to", canbao_to);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getContactInfo(String keyword) {
        Object uri = this.qiXinProperties.getUriGetContactInfo();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)keyword)) {
            urlParams.put("keyword", keyword);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getNewsListByName(String name, String skip, String tag_list, String sentiment, String company_sentiment, String class_types, String new_tag_list, String company_new_tag, String create_time_range) {
        Object uri = this.qiXinProperties.getUriGetNewsListByName();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)name)) {
            urlParams.put("name", name);
        }
        if (StringUtils.hasText((String)skip)) {
            urlParams.put("skip", skip);
        }
        if (StringUtils.hasText((String)tag_list)) {
            urlParams.put("tag_list", tag_list);
        }
        if (StringUtils.hasText((String)sentiment)) {
            urlParams.put("sentiment", sentiment);
        }
        if (StringUtils.hasText((String)company_sentiment)) {
            urlParams.put("company_sentiment", company_sentiment);
        }
        if (StringUtils.hasText((String)class_types)) {
            urlParams.put("class_types", class_types);
        }
        if (StringUtils.hasText((String)new_tag_list)) {
            urlParams.put("new_tag_list", new_tag_list);
        }
        if (StringUtils.hasText((String)company_new_tag)) {
            urlParams.put("company_new_tag", company_new_tag);
        }
        if (StringUtils.hasText((String)create_time_range)) {
            urlParams.put("create_time_range", create_time_range);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getBasicInfo(String keyword) {
        Object uri = this.qiXinProperties.getGetBasicInfoUri();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)keyword)) {
            urlParams.put("keyword", keyword);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getEntLogoByName(String name) {
        Object uri = this.qiXinProperties.getGetEntLogoByNameUri();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)name)) {
            urlParams.put("name", name);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getEntBriefByName(String name) {
        Object uri = this.qiXinProperties.getGetEntBriefByNameUri();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)name)) {
            urlParams.put("name", name);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getGetWebsites(String keyword, String skip) {
        Object uri = this.qiXinProperties.getGetWebsitesUri();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)keyword)) {
            urlParams.put("keyword", keyword);
        }
        if (StringUtils.hasText((String)skip)) {
            urlParams.put("skip", skip);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getPartners(String keyword, String skip) {
        Object uri = this.qiXinProperties.getGetPartnersUri();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)keyword)) {
            urlParams.put("keyword", keyword);
        }
        if (StringUtils.hasText((String)skip)) {
            urlParams.put("skip", skip);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getGetEmployees(String keyword, String skip) {
        Object uri = this.qiXinProperties.getGetEmployeesUri();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (StringUtils.hasText((String)keyword)) {
            urlParams.put("keyword", keyword);
        }
        if (StringUtils.hasText((String)skip)) {
            urlParams.put("skip", skip);
        }
        ArrayList<CallSite> concatParams = new ArrayList<CallSite>();
        for (String s : urlParams.keySet()) {
            concatParams.add((CallSite)((Object)(s + "=" + URLEncoder.encode((String)urlParams.get(s), StandardCharsets.UTF_8))));
        }
        uri = (String)uri + "?" + String.join((CharSequence)"&", concatParams);
        String result = this.getMessage((String)uri);
        return result;
    }

    @Override
    public String getMessage(String path) {
        String result = "";
        if (!this.qiXinProperties.getEnabled().booleanValue()) {
            log.warn("\u542f\u4fe1\u5b9d\u672a\u542f\u7528\uff01");
            return "{\n  \"data\": null,\n  \"sign\": \"1234\",\n  \"status\": \"400\",\n  \"message\": \"\u672a\u542f\u7528\"\n}";
        }
        Object status = "";
        String appkey = this.qiXinProperties.getAppkey();
        String secretKey = this.qiXinProperties.getSecretKey();
        Calendar calendar = Calendar.getInstance();
        Long timestamp = calendar.getTime().getTime();
        String sign = QiXinServiceImpl.getMD5Str(appkey + timestamp + secretKey);
        long start = System.currentTimeMillis();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Auth-version", "2.0");
        headers.put("appkey", "appkey");
        headers.put("timestamp", "" + timestamp);
        headers.put("sign", sign);
        headers.put("Content-Type", "application/json");
        try {
            String key = "QXB_CACHE_KEY:" + path;
            String resultCache = (String)this.redisUtils.get(key);
            if (StringUtils.hasText((String)resultCache)) {
                return resultCache;
            }
            HttpGet request = new HttpGet(path);
            request.setHeader("Auth-version", "2.0");
            request.setHeader("appkey", appkey);
            request.setHeader("timestamp", "" + timestamp);
            request.setHeader("sign", sign);
            request.setHeader("Content-Type", "application/json");
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                this.redisUtils.set(key, result, this.qiXinProperties.getCacheDay().intValue(), TimeUnit.DAYS);
            } else {
                log.error("\u8c03\u7528\u542f\u4fe1\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0cpath:{}; result:{};", (Object)path, (Object)result);
            }
            status = "" + response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            result = e.getMessage();
            log.error("\u8c03\u7528\u542f\u4fe1\u5b9d\u63a5\u53e3\u5f02\u5e38\uff0cpath:{}; ", (Object)path, (Object)e);
        }
        long time = System.currentTimeMillis() - start;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.QXB, path, RequestMethod.GET, null, JSONUtil.toJsonStr(headers), result, (String)status, time);
        return result;
    }

    public static String getMD5Str(String str) {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                String s = String.format("%02x", b);
                sb.append(s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public QiXinServiceImpl(ApiRequestLogService apiRequestLogService, QiXinProperties qiXinProperties, RedisUtils redisUtils) {
        this.apiRequestLogService = apiRequestLogService;
        this.qiXinProperties = qiXinProperties;
        this.redisUtils = redisUtils;
    }
}

