package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.VacationDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.util.List;

/**
 * @author sunxw
 * @description 假期表
 * @Date 2023/5/9
 */
@Transactional
public interface VacationRepo extends JpaRepository<VacationDO, Long>, JpaSpecificationExecutor<VacationDO> {

    @Query(value = "select sum(work_hours) from t_vacation where del_flag = 0 and natural_date >= ?1 and natural_date <= ?2", nativeQuery = true)
    Double selectWorkHoursByDate(LocalDate startDate, LocalDate endDate);

    @Query(value = "select * from t_vacation where YEAR(natural_date) = ?1", nativeQuery = true)
    List<VacationDO> selectByYear(int year);

    @Query(value = "update t_vacation set work_hours = :#{#vacation.getWorkHours()} where natural_date = :#{#vacation.getNaturalDate()}", nativeQuery = true)
    @Modifying
    int updateVacationByKey(@Param("vacation") VacationDO vacation);

    @Query(value = "update t_vacation set jde_export_flag = :#{#vacationDO.jdeExportFlag()} where natural_date = :#{#vacationDO.getNaturalDate()}", nativeQuery = true)
    @Modifying
    int updateJdeExportFlagByKey(@Param("vacationDO") VacationDO vacationDO);
}
