package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.payload.VacationPlayload;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.VacationVO;
import com.elitesland.tw.tw5.server.prd.my.dao.VacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.VacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.VacationRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author sunxw
 * @description 假期
 * @Date 2023/5/9
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class VacationServiceImpl implements VacationService {

    private final VacationDAO vacationDAO;
    private final VacationRepo vacationRepo;

    @Override
    public Double selectWorkHoursByDate(LocalDate startDate, LocalDate endDate) {
        return vacationRepo.selectWorkHoursByDate(startDate, endDate);
    }

    @Override
    public List<VacationVO> findListByYear(int year) {
        List<VacationDO> vacationDOList = vacationRepo.selectByYear(year);
        List<VacationVO> voList = new ArrayList<>();
        for (VacationDO vacationDO : vacationDOList) {
            VacationVO vo = new VacationVO();
            BeanUtils.copyProperties(vacationDO, vo);
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public void saveVacation(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setWorkHours(8F);
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties(vacation, vacationDO);
            int count = vacationRepo.updateVacationByKey(vacationDO);
            if (count == 0) {
                vacationRepo.save(vacationDO);
            }
        });
    }

    @Override
    public void saveJdeExport(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setJdeExportFlag((byte) 1);
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties(vacation, vacationDO);
            int count = vacationRepo.updateJdeExportFlagByKey(vacationDO);
            if (count == 0) {
                vacationRepo.save(vacationDO);
            }
        });
    }

}
