package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemConfigVO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemConfigDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemConfigRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 消息提醒dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemConfigDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemConfigRepo repo;
    private final QPrdSystemConfigDO qdo = QPrdSystemConfigDO.prdSystemConfigDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemConfigDO save(PrdSystemConfigDO ado) {
        return repo.save(ado);
    }
//

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemConfigVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemConfigVO.class,
                qdo.id,
                qdo.configCode,
                qdo.configName,
                qdo.configValue,
                qdo.createUserId,
                qdo.createTime
        )).from(qdo);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemConfigVO queryByKey(Long id) {
        JPAQuery<PrdSystemConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }
//


    /**
     * 动态查询集合
     *
     * @return 结果集合
     */
    public List<PrdSystemConfigVO> queryListDynamic() {
        JPAQuery<PrdSystemConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }
//

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
//    public long updateByKeyDynamic(PrdSystemConfigPayload payload) {
//        JPAUpdateClause update = jpaQueryFactory.update(qdo)
//                .where(qdo.id.eq(payload.getId()));
//
//        if (payload.getConfigCode() != null) {
//            update.set(qdo.ConfigCode, payload.getConfigCode());
//        }
//        if (payload.getConfigParentId() != null) {
//            update.set(qdo.ConfigParentId, payload.getConfigParentId());
//        }
//        if (payload.getConfigIndent() != null) {
//            update.set(qdo.ConfigIndent, payload.getConfigIndent());
//        }
//        if (payload.getConfigName() != null) {
//            update.set(qdo.ConfigName, payload.getConfigName());
//        }
//        if (payload.getConfigVersion() != null) {
//            update.set(qdo.ConfigVersion, payload.getConfigVersion());
//        }
//        if (payload.getConfigStatus() != null) {
//            update.set(qdo.ConfigStatus, payload.getConfigStatus());
//        }
//        if (payload.getRemark() != null) {
//            update.set(qdo.remark, payload.getRemark());
//        }
//        // 处理要设置成空的字段
//        List<String> nullFields = payload.getNullFields();
//        if (nullFields != null && nullFields.size() > 0) {
//
////            if (nullFields.contains("remindContent")) {
////                update.setNull(qdo.remindContent);
////            }
////            if (nullFields.contains("remindContentLocale")) {
////                update.setNull(qdo.remindContentLocale);
////            }
//            if (nullFields.contains("remark")) {
//                update.setNull(qdo.remark);
//            }
//        }
//        // 执行修改
//        return update.execute();
//    }
//

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
//    public long delete(List<Long> keys) {
//
//        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));
//
//        return delete.execute();
//    }
////
//    /**
//     * 逻辑删除
//     *
//     * @param key 主键
//     * @return 删除的行数
//     */
//    public long deleteSoft(Long key) {
//        JPAUpdateClause update = jpaQueryFactory.update(qdo)
//                .set(qdo.deleteFlag, 1)
//                .where(qdo.id.eq(key));
//        return update.execute();
//    }

//

//

//    /**
//     * 分页查询
//     *
//     * @param query 查询参数
//     * @return 分页结果
//     */
//    public PagingVO<PrdSystemConfigVO> queryPaging(PrdSystemConfigQuery query) {
//        JPAQuery<PrdSystemConfigVO> jpaQuery = getJpaQueryWhere(query);
//        QueryResults<PrdSystemConfigVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
//        return PagingVO.<PrdSystemConfigVO>builder().records(result.getResults()).total(result.getTotal()).build();
//    }
}
