/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.payload.VacationPlayload;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.VacationVO;
import com.elitesland.tw.tw5.server.prd.my.dao.VacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.VacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.VacationRepo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class VacationServiceImpl
implements VacationService {
    private static final Logger log = LoggerFactory.getLogger(VacationServiceImpl.class);
    private final VacationDAO vacationDAO;
    private final VacationRepo vacationRepo;

    public Double selectWorkHoursByDate(LocalDate startDate, LocalDate endDate) {
        return this.vacationRepo.selectWorkHoursByDate(startDate, endDate);
    }

    public List<VacationVO> findListByYear(int year) {
        List<VacationDO> vacationDOList = this.vacationRepo.selectByYear(year);
        ArrayList<VacationVO> voList = new ArrayList<VacationVO>();
        for (VacationDO vacationDO : vacationDOList) {
            VacationVO vo = new VacationVO();
            BeanUtils.copyProperties((Object)((Object)vacationDO), (Object)vo);
            voList.add(vo);
        }
        return voList;
    }

    public void saveVacation(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setWorkHours(Float.valueOf(8.0f));
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties((Object)vacation, (Object)((Object)vacationDO));
            int count = this.vacationRepo.updateVacationByKey(vacationDO);
            if (count == 0) {
                this.vacationRepo.save((Object)vacationDO);
            }
        });
    }

    public void saveJdeExport(List<VacationPlayload> list) {
        list.forEach(vacation -> {
            if (null == vacation.getWorkHours()) {
                vacation.setJdeExportFlag(Byte.valueOf((byte)1));
            }
            VacationDO vacationDO = new VacationDO();
            BeanUtils.copyProperties((Object)vacation, (Object)((Object)vacationDO));
            int count = this.vacationRepo.updateJdeExportFlagByKey(vacationDO);
            if (count == 0) {
                this.vacationRepo.save((Object)vacationDO);
            }
        });
    }

    public VacationServiceImpl(VacationDAO vacationDAO, VacationRepo vacationRepo) {
        this.vacationDAO = vacationDAO;
        this.vacationRepo = vacationRepo;
    }
}

