/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.shorturl.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlRequestLogPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlRequestLogQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRequestLogService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRequestLogVO;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.shorturl.convert.ShortUrlRequestLogConvert;
import com.elitesland.tw.tw5.server.prd.shorturl.dao.ShortUrlRequestLogDAO;
import com.elitesland.tw.tw5.server.prd.shorturl.entity.ShortUrlRequestLogDO;
import com.elitesland.tw.tw5.server.prd.shorturl.repo.ShortUrlRequestLogRepo;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ShortUrlRequestLogServiceImpl
extends BaseServiceImpl
implements ShortUrlRequestLogService {
    private static final Logger log = LoggerFactory.getLogger(ShortUrlRequestLogServiceImpl.class);
    private final ShortUrlRequestLogRepo shortUrlRequestLogRepo;
    private final ShortUrlRequestLogDAO shortUrlRequestLogDAO;

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public PagingVO<ShortUrlRequestLogVO> queryPaging(ShortUrlRequestLogQuery query) {
        return this.shortUrlRequestLogDAO.queryPaging(query);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<ShortUrlRequestLogVO> queryListDynamic(ShortUrlRequestLogQuery query) {
        return this.shortUrlRequestLogDAO.queryListDynamic(query);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRequestLogVO queryByKey(Long key) {
        ShortUrlRequestLogDO entity = this.shortUrlRequestLogRepo.findById(key).orElseGet(ShortUrlRequestLogDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ShortUrlRequestLogVO vo = ShortUrlRequestLogConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRequestLogVO insert(ShortUrlRequestLogPayload payload) {
        ShortUrlRequestLogDO entityDo = ShortUrlRequestLogConvert.INSTANCE.toDo(payload);
        return ShortUrlRequestLogConvert.INSTANCE.toVo((ShortUrlRequestLogDO)this.shortUrlRequestLogRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRequestLogVO update(ShortUrlRequestLogPayload payload) {
        ShortUrlRequestLogDO entity = this.shortUrlRequestLogRepo.findById(payload.getId()).orElseGet(ShortUrlRequestLogDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ShortUrlRequestLogDO entityDo = ShortUrlRequestLogConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ShortUrlRequestLogConvert.INSTANCE.toVo((ShortUrlRequestLogDO)this.shortUrlRequestLogRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.shortUrlRequestLogRepo.findById(id);
                if (!optional.isEmpty()) {
                    ShortUrlRequestLogDO entity = (ShortUrlRequestLogDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.shortUrlRequestLogRepo.save(entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public void log(ShortUrlRefVO shortUrlRefVO, HttpServletRequest request) {
        ShortUrlRequestLogDO entity = new ShortUrlRequestLogDO();
        entity.setShortId(null != shortUrlRefVO ? shortUrlRefVO.getId() : null);
        entity.setShortUrl(null != shortUrlRefVO ? shortUrlRefVO.getShortUrl() : null);
        entity.setLongUrl(null != shortUrlRefVO ? shortUrlRefVO.getLongUrl() : null);
        entity.setCreator(this.getLoginUserName());
        entity.setCreateUserId(this.getLoginUserId());
        entity.setCreateTime(LocalDateTime.now());
        entity.setBrowser(StringUtil.getBrowser(request));
        String ip = StringUtil.getIp(request);
        entity.setRequestIp(ip);
        entity.setAddress(StringUtil.getCityInfo(ip));
        this.shortUrlRequestLogRepo.save(entity);
    }

    public String getLoginUserName() {
        try {
            return GlobalUtil.getLoginUserName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Long getLoginUserId() {
        try {
            return GlobalUtil.getLoginUserId();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public ShortUrlRequestLogServiceImpl(ShortUrlRequestLogRepo shortUrlRequestLogRepo, ShortUrlRequestLogDAO shortUrlRequestLogDAO) {
        this.shortUrlRequestLogRepo = shortUrlRequestLogRepo;
        this.shortUrlRequestLogDAO = shortUrlRequestLogDAO;
    }
}

