package com.elitesland.tw.tw5.server.prd.schedule.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;

/**
 * @author zoey
 * @Description:日程重复表
 * @date 2022/4/19 - 21:06
 */
@Entity
@Table(name = "prd_schedule_repeat", indexes = {@Index(name = "schedule_index", columnList = "schedule_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_schedule_repeat", comment = "日程重复表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdScheduleRepeatDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("日程id")
    @Column(name = "schedule_id")
    private Long secheduleId;

    /**
     * 0 - 每日;1 - 每周;2 - 每月;5 - 每年;7 - 工作日
     */
    @Comment("重复类型")
    @Column(name = "repeat_type")
    private Integer repeatType;

    @Comment("重复结束时刻")
    private LocalDate repeatUntil;

    @Comment("是否自定义重复")
    @Column(name = "is_custom_repeat" )
    private Integer isCustomRepeat;

    @Comment("重复间隔")
    private Integer repeatInterval;

    @Comment("每周周几重复(0~6)")
    private String repeatDayOfWeek;

    @Comment("每月哪几天重复")
    private String repeatDayOfMonth;

    @Comment("排除日期String类型，逗号分隔")
    private String exdate;

}
