package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSettingPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSettingQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSettingService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemSettingConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSettingDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSettingDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 标准样例service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemSettingServiceImpl implements PrdSystemSettingService {
    private final PrdSystemSettingDAO dao;
    private final CacheUtil cacheUtil;


    @Transactional
    @Override
    public PrdSystemSettingVO insert(PrdSystemSettingPayload payload) {
        String settingKey = payload.getSettingKey();
        PrdSystemSettingVO vo = dao.selectInspect(settingKey);
        if (vo == null) {
            PrdSystemSettingDO ado = PrdSystemSettingConvert.INSTANCE.toDo(payload);
            dao.save(ado);
            cacheUtil.loadSystemSettingCache();
            return PrdSystemSettingConvert.INSTANCE.toVo(ado);
        }
        throw TwException.error("", "编号不可重复");
    }

    @Transactional
    @Override
    public Long update(PrdSystemSettingPayload payload) {
        Long key = payload.getId();
        String settingKey = payload.getSettingKey();
        PrdSystemSettingVO vo = dao.selectInspect(settingKey);
        if (vo == null) {
            dao.updateByKeyDynamic(payload);
            cacheUtil.loadSystemSettingCache();
            return 0L;
        } else {
            if (key.equals(vo.getId())) {
                dao.updateByKeyDynamic(payload);
                cacheUtil.loadSystemSettingCache();
                return 0L;
            }
        }
        throw TwException.error("", "编号不可重复");
    }

    @Transactional
    @Override
    public boolean delete(List<Long> keys) {
        dao.delete(keys);
        cacheUtil.loadSystemSettingCache();
        return true;
    }

    @Override
    public PrdSystemSettingVO queryByKey(Long key) {

        return dao.queryByKey(key);
    }

    @Override
    public PagingVO<PrdSystemSettingVO> paging(PrdSystemSettingQuery query) {
        PagingVO<PrdSystemSettingVO> evo = dao.queryPaging(query);
        List<PrdSystemSettingVO> vos = evo.getRecords();
        for (PrdSystemSettingVO vo : vos) {
            vo.setSystemModuleName(cacheUtil.transferSystemSelection("BUSINESS_MODULE", vo.getSystemModule()));
        }
        return evo;
    }

    @Override
    public PrdSystemSettingVO getSystemSettingByKey(String key) {

        return cacheUtil.getSystemSetting(key);
    }

    @Override
    public void clearCache() {
        cacheUtil.loadSystemSettingCache();
    }

    @Override
    public List<PrdSystemSettingVO> queryList(PrdSystemSettingQuery query) {
        return dao.queryListDynamic(query);
    }
}
