package com.elitesland.tw.tw5.server.prd.work.dao;

import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.work.entity.QPrdWorkAssignmentDO;
import com.elitesland.tw.tw5.server.prd.work.repo.PrdWorkAssignmentRepo;
import com.elitesland.tw.tw5.server.prd.work.entity.PrdWorkAssignmentDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdWorkAssignmentDAO {
    private final PrdWorkAssignmentRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdWorkAssignmentDO qdo = QPrdWorkAssignmentDO.prdWorkAssignmentDO;

    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgEmployeeDO qdoEmployee = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdWorkAssignmentDO save(PrdWorkAssignmentDO ado) {
        return repo.save(ado);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdWorkAssignmentPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getAssignmentNo() != null) {
            update.set(qdo.assignmentNo, payload.getAssignmentNo());
        }
        if (payload.getAssignmentName() != null) {
            update.set(qdo.assignmentName, payload.getAssignmentName());
        }
        if (payload.getPriority() != null) {
            update.set(qdo.priority, payload.getPriority());
        }
        if (payload.getAssignUserId() != null) {
            update.set(qdo.assignUserId, payload.getAssignUserId());
        }
        if (payload.getAssistUserIds() != null) {
            update.set(qdo.assistUserIds, payload.getAssistUserIds());
        }
        if (payload.getAssignmentType() != null) {
            update.set(qdo.assignmentType, payload.getAssignmentType());
        }
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        if (payload.getFinishDate() != null) {
            update.set(qdo.finishDate, payload.getFinishDate());
        }
        if (payload.getAssignmentStatus() != null) {
            update.set(qdo.assignmentStatus, payload.getAssignmentStatus());
        }
        if (payload.getActualStartDate() != null) {
            update.set(qdo.actualStartDate, payload.getActualStartDate());
        }
        if (payload.getActualFinishDate() != null) {
            update.set(qdo.actualFinishDate, payload.getActualFinishDate());
        }
        if (payload.getTaskId() != null) {
            update.set(qdo.taskId, payload.getTaskId());
        }
        if (payload.getFinishUserId() != null) {
            update.set(qdo.finishUserId, payload.getFinishUserId());
        }

        if (payload.getProgress() != null) {
            update.set(qdo.progress, payload.getProgress());
        }

        if (payload.getAssignmentDesc() != null) {
            update.set(qdo.assignmentDesc, payload.getAssignmentDesc());
        }
        if (payload.getFileCodes() != null) {
            update.set(qdo.fileCodes, payload.getFileCodes());
        }
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }

        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }


    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdWorkAssignmentVO queryByKey(Long id) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 更新状态
     *
     * @param ids
     * @param assignmentStatus
     * @return
     */
    public long updateAssignmentStatusByIds(List<Long> ids, String assignmentStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.assignmentStatus, assignmentStatus)
                .where(qdo.id.in(ids));
        return update.execute();
    }

    /**
     * 更新实际开始时间
     *
     * @param ids
     * @param actualStartDate
     * @return
     */
    public long updateActualStartDateByIds(List<Long> ids, LocalDate actualStartDate) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.actualStartDate, actualStartDate)
                .where(qdo.id.in(ids));
        return update.execute();
    }

    /**
     * 更新实际完成时间
     *
     * @param ids
     * @param actualFinishDate
     * @return
     */
    public long updateActualFinishDateByIds(List<Long> ids, LocalDate actualFinishDate) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.actualFinishDate, actualFinishDate)
                .where(qdo.id.in(ids));
        return update.execute();
    }

    /**
     * 更新进度
     *
     * @param ids
     * @param progress
     * @return
     */
    public long updateProgressByIds(List<Long> ids, Integer progress) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.progress, progress)
                .where(qdo.id.in(ids));
        return update.execute();
    }


    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdWorkAssignmentVO> queryListDynamic(PrdWorkAssignmentQuery query) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdWorkAssignmentVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdWorkAssignmentVO.class,
                qdo.id,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.updater,
                qdo.modifyUserId,
                qdo.modifyTime,
                qdo.remark,
                qdo.assignmentNo,
                qdo.assignmentName,
                qdo.priority,
                qdo.assignUserId,
                qdo.assistUserIds,
                qdo.assignmentType,
                qdo.startDate,
                qdo.finishDate,
                qdo.assignmentStatus,
                qdo.actualStartDate,
                qdo.actualFinishDate,
                qdo.taskId,
                qdo.finishUserId,
                qdo.progress,
                qdo.assignmentDesc,
                qdo.fileCodes,
                qdo.parentId
        )).from(qdo).leftJoin(qdoRef).on(qdo.assignUserId.eq(qdoRef.userId).and(qdoRef.deleteFlag.eq(0)).and(qdoRef.isCopy.eq(0)));
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdWorkAssignmentVO> queryPaging(PrdWorkAssignmentQuery query) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdWorkAssignmentVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdWorkAssignmentVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdWorkAssignmentVO> getJpaQueryWhere(PrdWorkAssignmentQuery query) {
        JPAQuery<PrdWorkAssignmentVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getAssignmentNo())) {
            jpaQuery.where(qdo.assignmentNo.like(SqlUtil.toSqlLikeString(query.getAssignmentNo())));
        }
        if (StringUtils.hasText(query.getAssignmentName())) {
            jpaQuery.where(qdo.assignmentName.like(SqlUtil.toSqlLikeString(query.getAssignmentName())));
        }
        if (StringUtils.hasText(query.getAssignmentStatus())) {
            jpaQuery.where(qdo.assignmentStatus.like(SqlUtil.toSqlLikeString(query.getAssignmentStatus())));
        }
        if (!CollectionUtils.isEmpty(query.getAssignmentStatusList())) {
            jpaQuery.where(qdo.assignmentStatus.in(query.getAssignmentStatusList()));
        }
        if (StringUtils.hasText(query.getPriority())) {
            jpaQuery.where(qdo.priority.eq(query.getPriority()));
        }
        if (StringUtils.hasText(query.getAssignmentType())) {
            jpaQuery.where(qdo.assignmentType.eq(query.getAssignmentType()));
        }
        if (!ObjectUtils.isEmpty(query.getAssistUserIds())) {
            jpaQuery.where(qdo.assistUserIds.contains(query.getAssistUserIds()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getAssignUserId())) {
            jpaQuery.where(qdo.assignUserId.eq(query.getAssignUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getParticipantUserId())) {
            jpaQuery.where(qdo.assistUserIds.like(String.valueOf(query.getParticipantUserId())).or(qdo.assignUserId.eq(query.getParticipantUserId()).or(qdo.createUserId.eq(query.getParticipantUserId()))));
        }
        if (!ObjectUtils.isEmpty(query.getEmpUserId())) {
            jpaQuery.where(qdo.assignUserId.eq(query.getEmpUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
        }

        if ((!ObjectUtils.isEmpty(query.getSearchStartDate())) && (!ObjectUtils.isEmpty(query.getSearchEndDate()))) {
            jpaQuery.where(qdo.startDate.between(query.getSearchStartDate(), query.getSearchEndDate()).or(qdo.finishDate.between(query.getSearchStartDate(), query.getSearchEndDate()))
                    .or(qdo.actualStartDate.between(query.getSearchStartDate(), query.getSearchEndDate())).or(qdo.actualFinishDate.between(query.getSearchStartDate(), query.getSearchEndDate()))
                    .or(qdo.startDate.after(query.getSearchStartDate()).and(qdo.finishDate.before(query.getSearchEndDate())))
                    .or(qdo.actualStartDate.after(query.getSearchStartDate()).and(qdo.actualFinishDate.before(query.getSearchEndDate()))));

        }

        if ((!ObjectUtils.isEmpty(query.getStartDate())) && (!ObjectUtils.isEmpty(query.getEndDate()))) {
            jpaQuery.where(qdo.startDate.between(query.getStartDate(), query.getEndDate()).or(qdo.finishDate.between(query.getStartDate(), query.getEndDate())));
        }

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.distinct();
    }
}
