/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTablePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.TableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.TableInfo;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u52a1\u5bf9\u8c61\u8868"})
@RestController
@RequestMapping(value={"/api/common/funConfig/businessTable"})
@RefreshScope
public class BusinessTableController {
    private static final Logger log = LoggerFactory.getLogger(BusinessTableController.class);
    private final BusinessTableService businessTableService;
    private final BusinessTableFieldsService businessTableFieldsService;
    @Value(value="${tw.generator.enabled:false}")
    private Boolean generatorEnabled;

    @PostMapping
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u65b0\u589e")
    public TwOutputUtil<BusinessTableVO> insert(@RequestBody BusinessTablePayload payload) {
        return TwOutputUtil.ok(this.businessTableService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u66f4\u65b0")
    public TwOutputUtil<BusinessTableVO> update(@RequestBody BusinessTablePayload payload) {
        return TwOutputUtil.ok(this.businessTableService.update(payload));
    }

    @PutMapping(value={"update"})
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u66f4\u65b0,\u652f\u6301\u7f6e\u7a7a \u7f6e\u7a7a\u7684\u5b57\u6bb5\u9700\u9700\u8981\u501f\u52a9 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessTablePayload payload) {
        return TwOutputUtil.ok(this.businessTableService.updateByKeyDynamic(payload));
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<BusinessTableVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.businessTableService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u5206\u9875")
    public TwOutputUtil<PagingVO<BusinessTableVO>> paging(BusinessTableQuery query) {
        return TwOutputUtil.ok(this.businessTableService.queryPaging(query));
    }

    @GetMapping(value={"/tables"})
    @ApiOperation(value="\u8bfb\u53d6\u6570\u636e\u5e93\u8868-\u5206\u9875")
    public TwOutputUtil<PagingVO<TableInfo>> tables(TableQuery query) {
        return TwOutputUtil.ok(this.businessTableService.tables(query));
    }

    @ApiOperation(value="\u540c\u6b65\u5b57\u6bb5\u6570\u636e")
    @PostMapping(value={"sync"})
    public TwOutputUtil syncColumn(@RequestBody List<Long> tableIdList) {
        this.businessTableFieldsService.syncColumn(tableIdList);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<BusinessTableVO>> queryList(BusinessTableQuery query) {
        return TwOutputUtil.ok(this.businessTableService.queryListDynamic(query));
    }

    @GetMapping(value={"/listAll"})
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u67e5\u8be2\u5217\u8868+\u5b57\u6bb5\u96c6\u5408")
    public TwOutputUtil<List<BusinessTableVO>> listAll(BusinessTableQuery query) {
        return TwOutputUtil.ok(this.businessTableService.listAll(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4e1a\u52a1\u5bf9\u8c61\u8868-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.businessTableService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u751f\u6210\u4ee3\u7801")
    @PostMapping(value={"generatorCode/{type}"})
    public TwOutputUtil generatorCode(@PathVariable Integer type, Long id, String projectModule, String apiGorupName, String packageName, String author, String moduleName, String prefix, boolean cover) {
        if (!this.generatorEnabled.booleanValue() && type == 0) {
            return TwOutputUtil.error("\u6b64\u73af\u5883\u4e0d\u5141\u8bb8\u751f\u6210\u4ee3\u7801\uff0c\u8bf7\u9009\u62e9\u9884\u89c8\u6216\u8005\u4e0b\u8f7d\u67e5\u770b\uff01");
        }
        switch (type) {
            case 0: {
                this.businessTableService.generator(id, projectModule, apiGorupName, packageName, author, moduleName, prefix, cover);
                break;
            }
            default: {
                return TwOutputUtil.error("\u6ca1\u6709\u8fd9\u4e2a\u9009\u9879");
            }
        }
        return TwOutputUtil.ok();
    }

    public BusinessTableController(BusinessTableService businessTableService, BusinessTableFieldsService businessTableFieldsService) {
        this.businessTableService = businessTableService;
        this.businessTableFieldsService = businessTableFieldsService;
    }
}

