/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.dao;

import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAddressVO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbAddressRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PrdAbAddressDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbAddressRepo repo;
    private final QPrdAbAddressDO qdo = QPrdAbAddressDO.prdAbAddressDO;

    public Long queryTW4IdById(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.addressIdV4).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (Long)jpaQuery.fetchFirst();
    }

    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.addressIdV4).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdAbAddressDO save(PrdAbAddressDO ado) {
        return (PrdAbAddressDO)((Object)this.repo.save((Object)ado));
    }

    private JPAQuery<PrdAbAddressVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdAbAddressVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.addressType, this.qdo.country, this.qdo.province, this.qdo.provinceName, this.qdo.city, this.qdo.cityName, this.qdo.district, this.qdo.districtName, this.qdo.detailAddress, this.qdo.remark, this.qdo.addressEmail, this.qdo.defaultAddress})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    public List<PrdAbAddressVO> queryList(Long bookId) {
        JPAQuery<PrdAbAddressVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PrdAbAddressVO> queryList(Long bookId, String addressType) {
        JPAQuery<PrdAbAddressVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.addressType.eq((Object)addressType));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public PrdAbAddressDAO(JPAQueryFactory jpaQueryFactory, PrdAbAddressRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

