/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.sms.service;

import cn.hutool.core.lang.Validator;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.sender.provider.SmsRpcService;
import com.elitescloud.coord.messenger.sender.provider.param.SimpleSmsDTO;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import com.elitesland.tw.tw5.server.prd.sms.config.TwSmsProperties;
import com.elitesland.tw.tw5.server.prd.sms.service.TwSmsService;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TwSmsServiceImpl
implements TwSmsService {
    private static final Logger log = LoggerFactory.getLogger(TwSmsServiceImpl.class);
    private final SmsRpcService smsRpcService;
    private final TwSmsProperties twSmsProperties;

    @Override
    public ApiResult<Boolean> sendTemplateMsg(String phone, String templateCode, Map map) {
        if (!this.twSmsProperties.getEnabled().booleanValue()) {
            return ApiResult.fail((String)"\u77ed\u4fe1\u670d\u52a1\u672a\u542f\u7528");
        }
        boolean isMobile = Validator.isMobile((CharSequence)phone);
        if (!isMobile) {
            log.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff0c\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff1a\u3010{}\u3011", (Object)phone);
            return ApiResult.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        TemplateSmsDTO smsDTO = new TemplateSmsDTO();
        HashSet<String> mobile = new HashSet<String>();
        mobile.add(phone);
        String smsTemplateCode = templateCode;
        smsDTO.setTemplateCode(smsTemplateCode);
        smsDTO.setSignName("\u57c3\u6797\u54f2CRM");
        smsDTO.setMobiles(mobile);
        smsDTO.setSubject("Elitesland");
        smsDTO.setBusinessType("CRM-TESTSEND");
        map.put("templateCode", smsTemplateCode);
        smsDTO.setTemplateParams(map);
        return this.sendTemplateMsg(smsDTO);
    }

    @Override
    public ApiResult<Boolean> sendTemplateMsg(TemplateSmsDTO smsDTO) {
        if (!this.twSmsProperties.getEnabled().booleanValue()) {
            return ApiResult.fail((String)"\u77ed\u4fe1\u670d\u52a1\u672a\u542f\u7528");
        }
        return this.smsRpcService.sendTemplateMsg(smsDTO);
    }

    @Override
    public ApiResult<Boolean> sendSimpleMsg(SimpleSmsDTO smsDTO) {
        if (!this.twSmsProperties.getEnabled().booleanValue()) {
            return ApiResult.fail((String)"\u77ed\u4fe1\u670d\u52a1\u672a\u542f\u7528");
        }
        return this.smsRpcService.sendSimpleMsg(smsDTO);
    }

    public TwSmsServiceImpl(SmsRpcService smsRpcService, TwSmsProperties twSmsProperties) {
        this.smsRpcService = smsRpcService;
        this.twSmsProperties = twSmsProperties;
    }
}

