/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemMenuPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemMenuQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemMenuDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemMenuRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemMenuDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemMenuRepo repo;
    private final QPrdSystemMenuDO qdo = new QPrdSystemMenuDO("prdSystemMenuDO");
    private final QPrdSystemMenuDO n_qdo = new QPrdSystemMenuDO("prdSystemMenuDO");

    public PrdSystemMenuDO save(PrdSystemMenuDO ado) {
        return (PrdSystemMenuDO)this.repo.save(ado);
    }

    private JPAQuery<PrdSystemMenuVO> getJpaQueryRelevanceSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemMenuVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.parentId, this.qdo.menuCode, this.qdo.menuName, this.qdo.portalRoute, this.qdo.menuIcon, this.qdo.sortIndex, this.qdo.menuStatus, this.n_qdo.menuName.as("parentMenuName"), this.qdo.remark, this.qdo.deleteFlag, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.n_qdo)).on((Predicate)this.qdo.parentId.longValue().eq(this.n_qdo.id));
    }

    private JPAQuery<PrdSystemMenuVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemMenuVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.parentId, this.qdo.menuCode, this.qdo.menuName, this.qdo.menuStatus, this.qdo.portalRoute, this.qdo.menuIcon, this.qdo.sortIndex, this.qdo.remark, this.qdo.deleteFlag, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo);
    }

    public List<PrdSystemMenuVO> queryList(PrdSystemMenuQuery query) {
        JPAQuery<PrdSystemMenuVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getMenuCode())) {
            jpaQuery.where((Predicate)this.qdo.menuCode.eq((Object)query.getMenuCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            jpaQuery.where((Predicate)this.qdo.parentId.eq((Object)query.getParentId()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    public List<PrdSystemMenuVO> usableList() {
        JPAQuery<PrdSystemMenuVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.menuStatus.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    public long updateByKeyDynamic(PrdSystemMenuPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if (payload.getMenuName() != null) {
            update.set((Path)this.qdo.menuName, (Object)payload.getMenuName());
        }
        if (payload.getMenuCode() != null) {
            update.set((Path)this.qdo.menuCode, (Object)payload.getMenuCode());
        }
        if (payload.getPortalRoute() != null) {
            update.set((Path)this.qdo.portalRoute, (Object)payload.getPortalRoute());
        }
        if (payload.getMenuIcon() != null) {
            update.set((Path)this.qdo.menuIcon, (Object)payload.getMenuIcon());
        }
        if (payload.getSortIndex() != null) {
            update.set(this.qdo.sortIndex, (Object)payload.getSortIndex());
        }
        if (payload.getMenuStatus() != null) {
            update.set(this.qdo.menuStatus, (Object)payload.getMenuStatus());
        }
        return update.execute();
    }

    public long delete(Long key) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return delete.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long updateStatus(List<Long> ids, Integer status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.menuStatus, (Object)status).where(new Predicate[]{this.qdo.id.in(ids)});
        return update.execute();
    }

    public PrdSystemMenuVO queryByKey(Long id) {
        JPAQuery<PrdSystemMenuVO> jpaQuery = this.getJpaQueryRelevanceSelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemMenuVO)jpaQuery.fetchFirst();
    }

    public PrdSystemMenuDAO(JPAQueryFactory jpaQueryFactory, PrdSystemMenuRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

