/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemWorkTypeQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemWorkTypeService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemWorkTypeDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemWorkTypeDO;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PrdSystemWorkTypeServiceImpl
implements PrdSystemWorkTypeService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemWorkTypeServiceImpl.class);
    private final PrdSystemWorkTypeDAO dao;
    private final CacheUtil cacheUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemSelectionService service;

    @Transactional
    public Long update(Long key, String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        this.dao.updateByKeyDynamic(key, sysType, sysWork, sysLevel, unitPrice);
        return 0L;
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(String sysType, String sysWork, String sysLevel, BigDecimal unitPrice) {
        this.dao.save(sysType, sysWork, sysLevel, unitPrice);
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        return true;
    }

    public PagingVO<PrdSystemWorkTypeVO> paging(PrdSystemWorkTypeQuery query) {
        PagingVO<PrdSystemWorkTypeVO> workTypeVOPagingVO = this.dao.queryPaging(query);
        workTypeVOPagingVO.getRecords().forEach(workTypeVO -> this.transferSystemSelection((PrdSystemWorkTypeVO)workTypeVO));
        return workTypeVOPagingVO;
    }

    public Map<String, Map<String, Map<String, BigDecimal>>> queryList() {
        List<PrdSystemWorkTypeVO> workTypeVOS = this.dao.queryList();
        HashMap<String, Map<String, Map<String, BigDecimal>>> workTypes = new HashMap<String, Map<String, Map<String, BigDecimal>>>();
        for (PrdSystemWorkTypeVO workTypeVO : workTypeVOS) {
            BigDecimal price;
            HashMap<String, BigDecimal> workType;
            this.transferSystemSelection(workTypeVO);
            String type = workTypeVO.getSysType();
            String work = workTypeVO.getSysWork();
            String level = workTypeVO.getSysLevel();
            BigDecimal unitPrice = workTypeVO.getUnitPrice();
            HashMap typeMap = (HashMap)workTypes.get(type);
            if (typeMap == null) {
                typeMap = new HashMap();
                workTypes.put(type, typeMap);
            }
            if ((workType = (HashMap<String, BigDecimal>)typeMap.get(work)) == null) {
                workType = new HashMap<String, BigDecimal>();
                typeMap.put(work, workType);
            }
            if ((price = (BigDecimal)workType.get(level)) != null) continue;
            workType.put(level, unitPrice);
        }
        return workTypes;
    }

    public void downloadPlus(HttpServletResponse response, PrdSystemWorkTypeQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/systemWorkTypeBatch.xlsx");
        List list = new ArrayList();
        if (StringUtils.hasText((String)query.getDownloadType()) && query.getDownloadType().equals("data")) {
            PagingVO<PrdSystemWorkTypeVO> evo = this.paging(query);
            list = evo.getRecords();
        }
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u4eba\u529b\u6210\u672c");
            this.excelUtil.generateRangeList(batchProjectSheet, 1, 1, "LOV", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 3, 1, "LOV", 2, "C");
            this.excelUtil.generateRangeList(batchProjectSheet, 5, 1, "LOV", 2, "E");
            if (batchProjectSheet != null) {
                if (list.size() > 0) {
                    int nextRow = 1;
                    for (PrdSystemWorkTypeVO dataPayload : list) {
                        XSSFRow row = batchProjectSheet.createRow(nextRow);
                        this.excelUtil.setCellValue((Row)row, 0, nextRow);
                        this.excelUtil.setCellValue((Row)row, 1, dataPayload.getSysTypeName());
                        this.excelUtil.setCellFormulas((Row)row, 2, "VLOOKUP(B:rowNo,LOV!A:B,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 3, dataPayload.getSysWorkName());
                        this.excelUtil.setCellFormulas((Row)row, 4, "VLOOKUP(D:rowNo,LOV!C:D,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 5, dataPayload.getSysLevelName());
                        this.excelUtil.setCellFormulas((Row)row, 6, "VLOOKUP(F:rowNo,LOV!E:F,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 7, dataPayload.getUnitPrice());
                        this.excelUtil.setCellValue((Row)row, 8, dataPayload.getCreateUserName());
                        this.excelUtil.setCellValue((Row)row, 9, dataPayload.getCreateTime());
                        ++nextRow;
                    }
                } else {
                    this.excelUtil.setCellFormulas((Row)(batchProjectSheet.getRow(1) == null ? batchProjectSheet.createRow(1) : batchProjectSheet.getRow(1)), 2, "VLOOKUP(B:rowNo,LOV!A:B,2,FALSE)");
                    this.excelUtil.setCellFormulas((Row)(batchProjectSheet.getRow(1) == null ? batchProjectSheet.createRow(1) : batchProjectSheet.getRow(1)), 4, "VLOOKUP(D:rowNo,LOV!C:D,2,FALSE)");
                    this.excelUtil.setCellFormulas((Row)(batchProjectSheet.getRow(1) == null ? batchProjectSheet.createRow(1) : batchProjectSheet.getRow(1)), 6, "VLOOKUP(F:rowNo,LOV!E:F,2,FALSE)");
                }
            }
            List sequenceist = this.service.selectByCondition(FunctionSelectionEnum.OrgEmployeeSequence.getCode());
            List typeList = this.service.selectByCondition(FunctionSelectionEnum.OrgEmployeeType.getCode());
            List levelList = this.service.selectByCondition(FunctionSelectionEnum.OrgEmployeeWorkLevel.getCode());
            Sheet sequenceSheet = workbook.getSheet("LOV");
            if (!CollectionUtils.isEmpty((Collection)sequenceist) && sequenceSheet != null) {
                int num = (sequenceist.size() > typeList.size() ? sequenceist.size() : typeList.size()) > levelList.size() ? (sequenceist.size() > typeList.size() ? sequenceist.size() : typeList.size()) : levelList.size();
                for (int i = 0; i < num; ++i) {
                    PrdSystemSelectionVO level;
                    PrdSystemSelectionVO type;
                    PrdSystemSelectionVO sequence;
                    Row row = sequenceSheet.createRow(i + 1);
                    if (i < sequenceist.size() && StringUtils.hasText((String)(sequence = (PrdSystemSelectionVO)sequenceist.get(i)).getSelectionName()) && StringUtils.hasText((String)sequence.getSelectionValue())) {
                        this.excelUtil.setCellValue(row, 0, sequence.getSelectionName());
                        this.excelUtil.setCellValue(row, 1, sequence.getSelectionValue());
                    }
                    if (i < typeList.size() && StringUtils.hasText((String)(type = (PrdSystemSelectionVO)typeList.get(i)).getSelectionName()) && StringUtils.hasText((String)type.getSelectionValue())) {
                        this.excelUtil.setCellValue(row, 2, type.getSelectionName());
                        this.excelUtil.setCellValue(row, 3, type.getSelectionValue());
                    }
                    if (i >= levelList.size() || !StringUtils.hasText((String)(level = (PrdSystemSelectionVO)levelList.get(i)).getSelectionName()) || !StringUtils.hasText((String)level.getSelectionValue())) continue;
                    this.excelUtil.setCellValue(row, 4, level.getSelectionName());
                    this.excelUtil.setCellValue(row, 5, level.getSelectionValue());
                }
            }
            String fileName = "\u4eba\u529b\u6210\u672c\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public boolean importWorkType(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u4eba\u529b\u6210\u672c");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<PrdSystemWorkTypeDO> workTypeDOs = new ArrayList<PrdSystemWorkTypeDO>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            PrdSystemWorkTypeDO workTypeDO = new PrdSystemWorkTypeDO();
            System.out.println("row.getCell(2)::" + row.getCell(1));
            String sysType = ExcelUtil.getCellFormatValue(row.getCell(2));
            if (sysType == null || sysType.length() < 1) break;
            String sysWork = ExcelUtil.getCellFormatValue(row.getCell(4));
            String sysLevel = ExcelUtil.getCellFormatValue(row.getCell(6));
            String unitPrice = ExcelUtil.getCellFormatValue(row.getCell(7));
            workTypeDO.setSysType(sysType);
            workTypeDO.setSysWork(sysWork);
            workTypeDO.setSysLevel(sysLevel);
            workTypeDO.setUnitPrice(new BigDecimal(unitPrice));
            workTypeDOs.add(workTypeDO);
        }
        this.dao.saveAll(workTypeDOs);
        return true;
    }

    void transferSystemSelection(PrdSystemWorkTypeVO vo) {
        vo.setSysTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.OrgEmployeeSequence.getCode(), vo.getSysType()));
        vo.setSysWorkName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.OrgEmployeeType.getCode(), vo.getSysWork()));
        vo.setSysLevelName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.OrgEmployeeSpecialtyLevel.getCode(), vo.getSysLevel()));
    }

    public PrdSystemWorkTypeServiceImpl(PrdSystemWorkTypeDAO dao, CacheUtil cacheUtil, ExcelUtil excelUtil, PrdSystemSelectionService service) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
        this.excelUtil = excelUtil;
        this.service = service;
    }
}

