package com.elitesland.tw.tw5.server.prd.ab.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author carl.wang
 * @Description:地址表
 */
@Entity
@Table(name = "prd_ab_address", indexes = {
        @Index(name = "book_index", columnList = "book_id"),
})
@org.hibernate.annotations.Table(appliesTo = "prd_ab_address", comment = "地址表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdAbAddressDO extends BaseModel {

    @Comment("地址簿id")
    @Column(name = "book_id")
    private Long bookId;

    @Comment("tw4.0地址表ID")
    @Column(name = "address_id_v4")
    private Long addressIdV4;

    @Comment("地址类型")
    @Column(name = "address_type")
    private String addressType;


    @Comment("国家")
    @Column(name = "country")
    private String country;

    @Comment("省")
    @Column(name = "province")
    private String province;

    @Comment("省")
    @Column()
    private String provinceName;

    @Comment("市")
    @Column(name = "city")
    private String city;

    @Comment("市")
    @Column()
    private String cityName;

    @Comment("区")
    @Column(name = "district")
    private String district;

    @Comment("区")
    @Column()
    private String districtName;

    @Comment("详细地址")
    @Column(name = "detail_address")
    private String detailAddress;

    @Comment("网址")
    @Column(name = "address_email")
    private String addressEmail;

    @Comment("默认地址")
    @Column()
    private Boolean defaultAddress;


}
