/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessPagePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessPageService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageListVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageVO;
import com.elitesland.tw.tw5.server.common.constants.BusinessPageTypeEnum;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessPageConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessPageDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessPageDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessPageRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessPageServiceImpl
extends BaseServiceImpl
implements BusinessPageService {
    private static final Logger log = LoggerFactory.getLogger(BusinessPageServiceImpl.class);
    private final BusinessPageRepo businessPageRepo;
    private final BusinessPageDAO businessPageDAO;

    public PagingVO<BusinessPageListVO> querySimplePaging(BusinessPageQuery query) {
        return this.businessPageDAO.querySimplePaging(query);
    }

    public PagingVO<BusinessPageVO> queryPaging(BusinessPageQuery query) {
        return this.businessPageDAO.queryPaging(query);
    }

    public List<BusinessPageVO> queryListDynamic(BusinessPageQuery query) {
        List<BusinessPageVO> list = this.businessPageDAO.queryListDynamic(query);
        return list;
    }

    public List<BusinessPageListVO> querySimpleListDynamic(BusinessPageQuery query) {
        List<BusinessPageListVO> list = this.businessPageDAO.querySimpleListDynamic(query);
        return list;
    }

    public List<BusinessPageVO> queryListDynamicPro(BusinessPageQuery query) {
        List<BusinessPageVO> list = this.businessPageDAO.queryListDynamic(query);
        this.expressionCondition(query, list);
        return list;
    }

    private void expressionCondition(BusinessPageQuery query, List<BusinessPageVO> list) {
        String visitTaskType = "";
        Long partnerId = 0L;
        if (query.getType() == null || query.getType().equals(BusinessPageTypeEnum.SPECIAL.getCode())) {
            // empty if block
        }
    }

    public Long count(BusinessPageQuery query) {
        return this.businessPageDAO.count(query);
    }

    public BusinessPageVO queryByKey(Long key) {
        BusinessPageDO entity = this.businessPageRepo.findById(key).orElseGet(BusinessPageDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPageVO vo = BusinessPageConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPageVO insert(BusinessPagePayload payload) {
        BusinessPageDO entityDo = BusinessPageConvert.INSTANCE.toDo(payload);
        return BusinessPageConvert.INSTANCE.toVo((BusinessPageDO)this.businessPageRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPageVO update(BusinessPagePayload payload) {
        BusinessPageDO entity = this.businessPageRepo.findById(payload.getId()).orElseGet(BusinessPageDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPageDO entityDo = BusinessPageConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessPageConvert.INSTANCE.toVo((BusinessPageDO)this.businessPageRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessPagePayload payload) {
        BusinessPageDO entity = this.businessPageRepo.findById(payload.getId()).orElseGet(BusinessPageDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessPageDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessPageRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessPageDO entity = (BusinessPageDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessPageRepo.save(entity);
                }
            });
        }
    }

    public BusinessPageServiceImpl(BusinessPageRepo businessPageRepo, BusinessPageDAO businessPageDAO) {
        this.businessPageRepo = businessPageRepo;
        this.businessPageDAO = businessPageDAO;
    }
}

