/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemHelpQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemHelpVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemHelpDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemHelpDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemHelpRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemHelpDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemHelpRepo repo;
    private final QPrdSystemHelpDO qdo = QPrdSystemHelpDO.prdSystemHelpDO;

    public PrdSystemHelpDO save(PrdSystemHelpDO ado) {
        return (PrdSystemHelpDO)this.repo.save(ado);
    }

    public long deleteSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public PagingVO<PrdSystemHelpVO> queryPaging(PrdSystemHelpQuery query) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<PrdSystemHelpVO> queryListDynamic(PrdSystemHelpQuery query) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    private JPAQuery<PrdSystemHelpVO> getJpaQueryWhere(PrdSystemHelpQuery query) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getHelpNo())) {
            jpaQuery.where((Predicate)this.qdo.helpNo.like(SqlUtil.toSqlLikeString(query.getHelpNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getHelpTitle())) {
            jpaQuery.where((Predicate)this.qdo.helpTitle.like(SqlUtil.toSqlLikeString(query.getHelpTitle())));
        }
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<PrdSystemHelpVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemHelpVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.helpNo, this.qdo.helpTitle, this.qdo.articleUrl, this.qdo.linkUrl, this.qdo.remark, this.qdo.tenantId})).from((EntityPath)this.qdo);
    }

    public PrdSystemHelpVO queryByKey(Long id) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemHelpVO)jpaQuery.fetchFirst();
    }

    public List<PrdSystemHelpVO> queryByTitle(String helpTitle) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.helpTitle.eq((Object)helpTitle));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdSystemHelpDAO(JPAQueryFactory jpaQueryFactory, PrdSystemHelpRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

