package com.elitesland.tw.tw5.server.prd.sms.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * tw 短信配置
 *
 * @author duwh
 * @date 2023/06/08
 */
@Getter
@Setter
@ConfigurationProperties("tw.sms")
public class TwSmsProperties {

    /**
     * 是否启用
     */
    private Boolean enabled = false;


    /**
     * 销售拜访 客户评价短信模版
     *
     * ${name}，您好！感谢您抽出的宝贵时间，欢迎您对此次拜访作出评价  crm.tw.elitesland.com${jumpuri}
     */
    private String smsTemplateCodeVisitTaskEval = "SMS_460975258";

    /**
     * 销售拜访短信 对应h5路由地址 （客户评价跳转）
     */
    private String visitTaskEvalRedirectUri = "crm/#/pages/crm/customerVisit/customerEval/customerEval";


}
