/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.log.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.log.entity.ComLogDO;
import com.elitesland.tw.tw5.server.common.log.entity.QComLogDO;
import com.elitesland.tw.tw5.server.common.log.repo.ComLogRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtilPlus;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class ComLogDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ComLogRepo repo;
    private final QComLogDO qdo = QComLogDO.comLogDO;

    public ComLogDO save(ComLogDO ado) {
        return (ComLogDO)this.repo.save(ado);
    }

    public List<ComLogDO> saveAll(List<ComLogDO> dos) {
        return this.repo.saveAll(dos);
    }

    private JPAQuery<ComLogVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ComLogVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.creator, this.qdo.createUserId, this.qdo.objectId, this.qdo.logType, this.qdo.logContent, this.qdo.versionNo, this.qdo.remark, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ComLogVO> getJpaQueryWhere(ComLogQuery query) {
        JPAQuery<ComLogVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(SqlUtilPlus.getSortedColumn(query.getOrders(), this.qdo));
        return jpaQuery;
    }

    private Predicate where(ComLogQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getLogType())) {
            list.add(this.qdo.logType.eq((Object)query.getLogType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjectId())) {
            list.add(this.qdo.objectId.eq((Object)query.getObjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVersionNo())) {
            list.add(this.qdo.versionNo.eq((Object)query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString1())) {
            list.add(this.qdo.extString1.eq((Object)query.getExtString1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString2())) {
            list.add(this.qdo.extString2.eq((Object)query.getExtString2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString3())) {
            list.add(this.qdo.extString3.eq((Object)query.getExtString3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString4())) {
            list.add(this.qdo.extString4.eq((Object)query.getExtString4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLogContent())) {
            list.add(this.qdo.logContent.like("%" + query.getLogContent() + "%"));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<ComLogVO> queryListDynamic(ComLogQuery query) {
        JPAQuery<ComLogVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ComLogVO> queryPaging(ComLogQuery query) {
        JPAQuery<ComLogVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public ComLogVO queryByKey(Long id) {
        JPAQuery<ComLogVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ComLogVO)jpaQuery.fetchFirst();
    }

    public ComLogDAO(JPAQueryFactory jpaQueryFactory, ComLogRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

