package com.elitesland.tw.tw5.server.prd.ab.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author carl.wang
 * @Description:开票表
 */
@Entity
@Table(name = "prd_ab_invoice", indexes = {
        @Index(name = "book_index", columnList = "book_id"),
})
@org.hibernate.annotations.Table(appliesTo = "prd_ab_invoice", comment = "开票表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdAbInvoiceDO extends BaseModel {

    @Comment("地址簿id")
    @Column(name = "book_id")
    private Long bookId;

    @Comment("tw4.0开票表ID")
    @Column(name = "invoice_id_v4")
    private Long invoiceIdV4;

    @Comment("发票信息")
    @Column(name = "invoice_message")
    private String invoiceMessage;

    @Comment("发票抬头")
    @Column(name = "invoice_title")
    private String invoiceTitle;

    @Comment("税率")
    @Column(name = "tax_rete")
    private String taxRete;

    @Comment("税号")
    @Column(name = "tax_no")
    private String taxNo;

    @Comment("开票类型")
    @Column(name = "invoice_type")
    private String invoiceType;

    @Comment("开票地址")
    @Column(name = "invoice_address")
    private String invoiceAddress;

    @Comment("电话")
    @Column(name = "invoice_phone")
    private String invoicePhone;

    @Comment("开户行")
    @Column(name = "deposit_bank")
    private String depositBank;

    @Comment("账户")
    @Column(name = "invoice_account")
    private String invoiceAccount;

    @Comment("币种")
    @Column(name = "currency")
    private String currency;

    @Comment("默认")
    @Column(name = "is_default")
    private Boolean defaultFlag;
}
