package com.elitesland.tw.tw5.server.prd.app.service;

import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.app.payload.AppVersionPayload;
import com.elitesland.tw.tw5.api.prd.app.query.AppVersionQuery;
import com.elitesland.tw.tw5.api.prd.app.service.AppVersionService;
import com.elitesland.tw.tw5.api.prd.app.vo.AppVersionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.app.convert.AppVersionConvert;
import com.elitesland.tw.tw5.server.prd.app.entity.AppVersionDO;
import com.elitesland.tw.tw5.server.prd.app.repo.AppVersionRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * APP版本管理
 *
 * @author duwh
 * @date 2023-02-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AppVersionServiceImpl implements AppVersionService {

    private final AppVersionRepo appVersionRepo;
    private final FileService fileService;

    @Override
    public PagingVO<AppVersionVO> paging(AppVersionQuery query) {
        Page<AppVersionDO> page = appVersionRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(AppVersionConvert.INSTANCE::toVo));
    }

    @Override
    public List<AppVersionVO> queryList(AppVersionQuery query) {
        return AppVersionConvert.INSTANCE.toVoList(appVersionRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public AppVersionVO queryByKey(Long key) {
        AppVersionDO entity = appVersionRepo.findById(key).orElseGet(AppVersionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AppVersionVO vo = AppVersionConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AppVersionVO insert(AppVersionPayload payload) {
        dataProcess(payload);
        AppVersionDO entityDo = AppVersionConvert.INSTANCE.toDo(payload);
        return AppVersionConvert.INSTANCE.toVo(appVersionRepo.save(entityDo));
    }

    private void dataProcess(AppVersionPayload payload) {
        if (null == payload.getShowFlag()) {
            payload.setShowFlag(0);
        }
        final String fileCode = payload.getFileCode();
        if (StringUtils.hasText(fileCode)) {
            //https://tw5-test.elitesland.com/tw-server5/com/file/v1/1629037701401546752/download
            payload.setDownloadUrl("/com/file/v1/"+fileCode+"/download");
            //final ApiResult apiResult = fileService.get(fileCode);
            //final FileObjRespVO data = (FileObjRespVO) apiResult.getData();
            // 因架构附件bug问题，下载地址不正确
            //final String urlDownload = data.getUrlDownload();
            //payload.setDownloadUrl(urlDownload);
        } /*else {
            throw TwException.error("","附件必填");
        }*/
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AppVersionVO update(AppVersionPayload payload) {
        AppVersionDO entity = appVersionRepo.findById(payload.getId()).orElseGet(AppVersionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        dataProcess(payload);
        AppVersionDO entityDo = AppVersionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AppVersionConvert.INSTANCE.toVo(appVersionRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<AppVersionDO> optional = appVersionRepo.findById(id);
                if (!optional.isEmpty()) {
                    AppVersionDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    appVersionRepo.save(entity);
                }
            });
        }
    }

    @Override
    public AppVersionVO getCurrentVersion() {
        AppVersionQuery query = new AppVersionQuery();
        query.setShowFlag(1);
        List<OrderItem> orderItemList = new ArrayList<>();
        OrderItem orderItem = OrderItem.desc("version");
        OrderItem orderItem2 = OrderItem.desc("createTime");
        orderItemList.add(orderItem);
        orderItemList.add(orderItem2);
        query.setOrders(orderItemList);
        query.setSize(1);
        final PagingVO<AppVersionVO> paging = paging(query);
        if (paging != null) {
            final List<AppVersionVO> records = paging.getRecords();
            if (!CollectionUtils.isEmpty(records)) {
                return records.get(0);
            }
        }
        return null;
    }

}
