package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_org_organization",
        indexes = {@Index(name = "dimension_index", columnList = "dimension_id"),
                @Index(name = "orgv4_index", columnList = "org_id_v4")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_organization", comment = "组织表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgOrganizationDO extends BaseModel implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @Comment("维度id")
    @Column(name = "dimension_id")
    private Long dimensionId;

    @Comment("tw4.0组织ID")
    @Column(name = "org_id_v4")
    private Long orgIdV4;

    @Comment("组织改变前ID")
    @Column()
    private Long changeId;

    @Comment("组织名称")
    @Column()
    private String orgName;

    @Comment("组织编号")
    @Column()
    private String orgCode;

    @Comment("组织状态")
    @Column()
    private String orgStatus = "CREATE";

    @Comment("负责人ID")
    @Column()
    private Long manageId = 0L;

    @Comment("是否是bu")
    @Column()
    private Integer isBu = 0;

    @Comment("是否是拷贝数据")
    @Column()
    private Integer isCopy = 0;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;
    private String extString7;
    private String extString8;
    private String extString9;
    private String extString10;

    @Override
    public Object clone() {
        PrdOrgOrganizationDO stu = null;
        try {
            stu = (PrdOrgOrganizationDO) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return stu;
    }
}
