package com.elitesland.tw.tw5.server.prd.schedule.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdCalendarSharePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxCalendarSharePayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarShareVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdCalendarShareConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarShareDAO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdCalendarShareDO;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdCalendarConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarDAO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:日历管理service
 * @date 2022/4/19 - 21:37
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdCalendarServiceImpl implements PrdCalendarService {

    private final PrdCalendarDAO dao;
    private final PrdCalendarShareDAO calendarShareDAO;
    private final QyWxCommunicationService wxService;
    private final PrdOrgEmployeeDAO employeeDAO;


    /*
     * @Author Zoey
     * @Description 新增或者更新
     * @Date 21:38 2022/4/23
     * @Param [com.elitesland.tw.tw5crm.api.prd.schedule.payload.PrdCalendarPayload]
     * @return com.elitesland.tw.tw5crm.api.prd.schedule.vo.PrdCalendarVO
     **/
    @Transactional
    @Override
    public PrdCalendarVO insertOrUpdate(PrdCalendarPayload payload) {
        if(payload.getTitle()!=null && payload.getTitle().contains("undefined")){
            String title = payload.getTitle();
            String loginUserName = GlobalUtil.getLoginUserName();
            title = title.replace("undefined", loginUserName);
            payload.setTitle(title);
        }
        if(payload.getDescription()!=null && payload.getDescription().contains("undefined")){
            String description = payload.getDescription();
            String loginUserName = GlobalUtil.getLoginUserName();
            description=description.replace("undefined",loginUserName);
            payload.setDescription(description);
        }
        boolean isNew = payload.getId() == null ? true : false;
        PrdCalendarDO ado = PrdCalendarConvert.INSTANCE.toDo(payload);
        if (ado.getDefaultFlag() == null) {
            ado.setDefaultFlag(0);
        }
        ado = dao.save(ado);
        payload.setId(ado.getId());
        payload.setCreateUserId(ado.getCreateUserId());
        //插入共享成员
        List<PrdCalendarSharePayload> shares = payload.getShares();
        Long calId = ado.getId();
        //获取共享成员列表
        List<PrdCalendarShareVO> prdCalendarShareVOS = calendarShareDAO.queryByCalId(calId);
        if (shares != null && !shares.isEmpty() && !payload.getSkipShares()) {
            for (PrdCalendarSharePayload share : shares) {
                boolean b = prdCalendarShareVOS.stream().anyMatch(m -> m.getUserId().equals(share.getUserId()));
                if (!b) {
                    share.setCalId(calId);
                    PrdCalendarShareDO shareDO = PrdCalendarShareConvert.INSTANCE.toDo(share);
                    calendarShareDAO.save(shareDO);
                }
            }
            //TODO:有时间简化一下
            for (PrdCalendarShareVO shareVO : prdCalendarShareVOS) {
                boolean b = shares.stream().anyMatch(m -> m.getUserId().equals(shareVO.getUserId()));
                List<Long> ids = new ArrayList<>();
                if (!b) {
                    ids.add(shareVO.getId());
                }
                if (!ids.isEmpty()) {
                    //删除该条目
                    calendarShareDAO.deleteSoft(ids);
                }
            }
        } else {
            List<Long> collect = prdCalendarShareVOS.stream().map(item -> item.getId()).collect(Collectors.toList());
            calendarShareDAO.deleteSoft(collect);
        }
        //如果是从企业微信端过来的请求，不用调同步
        if (payload.getFromQyWx() == null || !payload.getFromQyWx()) {
            if (isNew) {
                //同步数据到微信
                String qywxCalId = wxService.saveCalendar(transferToQyWxPayload(payload));
                //更新本地日历企业微信id
                ado.setQyWxCalId(qywxCalId);
                dao.save(ado);
            } else {
                PrdCalendarVO prdCalendarVO = dao.queryByKey(payload.getId());
                payload.setCreateUserId(prdCalendarVO.getCreateUserId());
                payload.setQyWxCalId(prdCalendarVO.getQyWxCalId());
                wxService.updateCalendar(transferToQyWxPayload(payload));
            }

        }
        return PrdCalendarConvert.INSTANCE.toVo(ado);
    }

    /*
     * @Author Zoey
     * @Description 将日历payload转为微信payload
     * @Date 17:40 2022/4/23
     **/
    @Override
    public QyWxCalendarPayload transferToQyWxPayload(PrdCalendarPayload calendarPayload) {
        QyWxCalendarPayload payload = new QyWxCalendarPayload();
        payload.setCal_id(calendarPayload.getQyWxCalId());
        payload.setSummary(calendarPayload.getTitle());
        payload.setDescription(calendarPayload.getDescription());
        payload.setReadonly(calendarPayload.getReadonly());
        payload.setSet_as_default(calendarPayload.getDefaultFlag());
        Long createUserId = calendarPayload.getCreateUserId();
        String weComId = getWeComId(createUserId);
        payload.setOrganizer(weComId);
        List<QyWxCalendarSharePayload> qyWxShares = new ArrayList<>();
        List<PrdCalendarSharePayload> shares = calendarPayload.getShares();
        if (shares != null && !shares.isEmpty()) {
            for (PrdCalendarSharePayload share : shares) {
                QyWxCalendarSharePayload qyWxShare = new QyWxCalendarSharePayload();
                qyWxShare.setReadonly(share.getReadonly());
                Long userId = share.getUserId();
                qyWxShare.setUserid(getWeComId(userId));
                qyWxShares.add(qyWxShare);
            }
        }
        payload.setShares(qyWxShares);
        payload.setColor(calendarPayload.getColor());
        return payload;
    }


    /*
     * @Author Zoey
     * @Description 将微信payload转为日历payload
     * @Date 17:40 2022/4/23
     **/
    @Override
    public PrdCalendarPayload transferToPrdPayload(QyWxCalendarPayload calendarPayload) {
        PrdCalendarPayload payload = new PrdCalendarPayload();
        payload.setQyWxCalId(calendarPayload.getCal_id());
        payload.setTitle(calendarPayload.getSummary());
        payload.setDescription(calendarPayload.getDescription());
        payload.setReadonly(calendarPayload.getReadonly());
        payload.setDefaultFlag(calendarPayload.getSet_as_default());
        Long createUserId = getUserIdByWeComId(calendarPayload.getOrganizer());
        payload.setCreateUserId(createUserId);
        List<PrdCalendarSharePayload> prdShares = new ArrayList<>();
        List<QyWxCalendarSharePayload> shares = calendarPayload.getShares();
        if (shares != null && !shares.isEmpty()) {
            List<QyWxCalendarSharePayload> shares1 = JSON.parseArray(String.valueOf(shares), QyWxCalendarSharePayload.class);
            for (QyWxCalendarSharePayload share : shares1) {
                PrdCalendarSharePayload prdShare = new PrdCalendarSharePayload();
                prdShare.setReadonly(share.getReadonly());
                Long userId = getUserIdByWeComId(share.getUserid());
                prdShare.setUserId(userId);
                prdShares.add(prdShare);
            }
        }
        payload.setShares(prdShares);
        payload.setColor(calendarPayload.getColor());
        return payload;
    }


    @Override
    public List<PrdCalendarVO> queryList(PrdCalendarQuery query) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long id = userDetails == null ? 0 : userDetails.getUser().getId();
        // 查询主表
        List<PrdCalendarVO> prdCalendarVOS = dao.queryByCreateUserId(id);
        List<Long> calIdsByCreateUserId = prdCalendarVOS.stream().map(item -> item.getId()).distinct().collect(Collectors.toList());
        // 查询share表
        List<PrdCalendarShareVO> prdCalendarShareVOS = calendarShareDAO.queryByUserId(id);
        List<Long> calIdsByShares = prdCalendarShareVOS.stream().map(item -> item.getCalId()).distinct().collect(Collectors.toList());
        calIdsByShares.addAll(calIdsByCreateUserId);
        List<Long> collect = calIdsByShares.stream().distinct().collect(Collectors.toList());
        query.setCalIds(collect);
        return dao.queryListDynamic(query);
    }

    @Transactional
    @Override
    public void deleteSoft(List<Long> asList) {
        //同步删除企业微信日历
        for (Long calendarId : asList) {
            PrdCalendarVO prdCalendarVO = dao.queryByKey(calendarId);
            String qyWxCalId = prdCalendarVO.getQyWxCalId();
            if (qyWxCalId != null) {
                wxService.deleteCalendar(qyWxCalId);
            }
        }
        //删除日历
        dao.deleteSoft(asList);
    }

    @Override
    public PrdCalendarVO queryDetail(Long id) {
        PrdCalendarVO prdCalendarVO = dao.queryByKey(id);
        if (prdCalendarVO != null) {
            List<PrdCalendarShareVO> shares = calendarShareDAO.queryByCalId(prdCalendarVO.getId());
            //日历的创建人不等于分享人的userId
            shares = shares.stream().filter(item -> !item.getUserId().equals(prdCalendarVO.getCreateUserId())).collect(Collectors.toList());
            prdCalendarVO.setShares(shares);
        }
        return prdCalendarVO;
    }


    /**
     * 查询企业微信id
     *
     * @param userId
     * @return userId tw用户id
     */
    @Override
    public String getWeComId(Long userId) {
        //PrdOrgEmployeeDO employeeDO = employeeDAO.queryByUserId(userId);
        //String weComId = employeeDO.getWecomId();
        //if (weComId == null) {
        //    throw TwException.error("", "同步到企业微信失败，请维护" + employeeDO.getEmployeeName() + "的企业微信账号！");
        //}
        //return weComId;
        return "";
    }

    /**
     * 根据企业微信id查询用户id
     *
     * @param userid 企业微信用户id
     * @return
     */
    @Override
    public Long getUserIdByWeComId(String userid) {
        PrdOrgEmployeeDO employeeDO = employeeDAO.queryByWeComeId(userid);
        if (employeeDO == null) {
            throw TwException.error("", "企业微信同步到本地失败！");
        }
        Long userId = employeeDO.getUserId();
        if (userId == null) {
            throw TwException.error("", "企业微信同步到本地失败！");
        }
        return userId;
    }

}
