package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdCommentPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdCommentQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdCommentVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * 评论服务
 *
 * @author duwh
 * @date 2022/11/22
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdCommentController {

    private final PrdCommentService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/comment")
    public TwOutputUtil insert(PrdCommentPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }


    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/comment")
    public TwOutputUtil update(PrdCommentPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/comment/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdCommentVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/comment/paging")
    //@UdcNameClass
    public TwOutputUtil paging(PrdCommentQuery query) {
        PagingVO<PrdCommentVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 分页带层级 包含二级评论
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/comment/pagingPro")
    //@UdcNameClass
    public TwOutputUtil pagingPro(PrdCommentQuery query) {
        PagingVO<PrdCommentVO> paging = service.pagingPro(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     * 带层级 包含二级评论
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/comment/listPro")
    //@UdcNameClass
    public TwOutputUtil queryListPro(PrdCommentQuery query) {
        List<PrdCommentVO> vos = service.queryListPro(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/comment/list")
    //@UdcNameClass
    public TwOutputUtil queryList(PrdCommentQuery query) {
        List<PrdCommentVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/comment/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
