package com.elitesland.tw.tw5.server.common.funConfig.dao;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessPagePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageVO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessPageDO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.QBusinessPageDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessPageRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 页面配置
 *
 * @author duwh
 * @date 2023-06-20
 */
@Repository
@RequiredArgsConstructor
public class BusinessPageDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessPageRepo repo;
    private final QBusinessPageDO qdo = QBusinessPageDO.businessPageDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessPageVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessPageVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 名称
                qdo.name,
                // 编码
                qdo.code,
                // 类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟)
                qdo.type,
                // 功能主键 prd_system_function.id
                qdo.functionId,
                // 页面配置json内容
                qdo.jsonContent,
                // 是否启用 true/1 启用 false/0 不启用
                qdo.enabled,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessPageVO> getJpaQueryWhere(BusinessPageQuery query) {
        JPAQuery<BusinessPageVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessPageQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessPageQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 名称 精确 */
        if (!ObjectUtils.isEmpty(query.getName())) {
            list.add(qdo.name.eq(query.getName()));
        }
        /** 编码 精确 */
        if (!ObjectUtils.isEmpty(query.getCode())) {
            list.add(qdo.code.eq(query.getCode()));
        }
        /** 类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟) 精确 */
        if (!ObjectUtils.isEmpty(query.getType())) {
            list.add(qdo.type.eq(query.getType()));
        }
        /** 功能主键 prd_system_function.id 精确 */
        if (!ObjectUtils.isEmpty(query.getFunctionId())) {
            list.add(qdo.functionId.eq(query.getFunctionId()));
        }
        /** 页面配置json内容 精确 */
        if (!ObjectUtils.isEmpty(query.getJsonContent())) {
            list.add(qdo.jsonContent.eq(query.getJsonContent()));
        }
        /** 是否启用 true/1 启用 false/0 不启用 精确 */
        if (!ObjectUtils.isEmpty(query.getEnabled())) {
            list.add(qdo.enabled.eq(query.getEnabled()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessPageVO queryByKey(Long id) {
        JPAQuery<BusinessPageVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessPageVO> queryListDynamic(BusinessPageQuery query) {
        JPAQuery<BusinessPageVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessPageVO> queryPaging(BusinessPageQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessPageVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessPageVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessPageVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessPageDO save(BusinessPageDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessPageDO> saveAll(List<BusinessPageDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessPagePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 名称
        if (payload.getName() != null) {
            update.set(qdo.name, payload.getName());
        }
        // 编码
        if (payload.getCode() != null) {
            update.set(qdo.code, payload.getCode());
        }
        // 类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟)
        if (payload.getType() != null) {
            update.set(qdo.type, payload.getType());
        }
        // 功能主键 prd_system_function.id
        if (payload.getFunctionId() != null) {
            update.set(qdo.functionId, payload.getFunctionId());
        }
        // 页面配置json内容
        if (payload.getJsonContent() != null) {
            update.set(qdo.jsonContent, payload.getJsonContent());
        }
        // 是否启用 true/1 启用 false/0 不启用
        if (payload.getEnabled() != null) {
            update.set(qdo.enabled, payload.getEnabled());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 名称
            if (nullFields.contains("name")) {
                update.setNull(qdo.name);
            }
            // 编码
            if (nullFields.contains("code")) {
                update.setNull(qdo.code);
            }
            // 类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟)
            if (nullFields.contains("type")) {
                update.setNull(qdo.type);
            }
            // 功能主键 prd_system_function.id
            if (nullFields.contains("functionId")) {
                update.setNull(qdo.functionId);
            }
            // 页面配置json内容
            if (nullFields.contains("jsonContent")) {
                update.setNull(qdo.jsonContent);
            }
            // 是否启用 true/1 启用 false/0 不启用
            if (nullFields.contains("enabled")) {
                update.setNull(qdo.enabled);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

