package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 个人管理
 *
 * @author wangding
 */
@Api("个人管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_SYSTEM)
@RequestMapping("/api/my")
@Slf4j
public class PrdUserController {

    private final PrdUserService service;


    /**
     * 查询个人菜单
     *
     * @return result
     */
    @GetMapping("/user/queryMenus")
    public TwOutputUtil queryMenus() {
        return TwOutputUtil.ok(service.queryMenus());
    }


    /**
     * 查询个人复合能力
     *
     * @return result
     */
    @PutMapping("/user/queryCompositeVO")
    public TwOutputUtil queryCompositeVO(Long userId) {
        return TwOutputUtil.ok(service.queryUserComposite(userId));
    }

    /**
     * 查询个人数据
     * <p>
     * 移动端see com.elitesland.tw.tw5.server.prd.app.controller.AppUserController#queryDetailForMobile()
     *
     * @return result
     */
    @PutMapping("/user/queryDetail")
    public TwOutputUtil queryDetail() {
        return TwOutputUtil.ok(service.queryUserDetail());
    }

    /**
     * 修改密码
     *
     * @param oldPassword 当前密码
     * @param newPassword 新密码
     * @return result
     */
    @ApiOperation("")
    @GetMapping("/user/updatePassword")
    public TwOutputUtil updatePassword(String oldPassword, String newPassword) {
        service.updatePassword(oldPassword, newPassword);
        return TwOutputUtil.ok();
    }

    /**
     * 修改个人快捷入口
     *
     * @param shortcutIds 快捷入口ids(","拼接字符串)
     * @return result
     */
    @PutMapping("/user/updateShortcut")
    public TwOutputUtil updateShortcut(String shortcutIds) {
        service.updateShortcut(shortcutIds);
        return TwOutputUtil.ok();
    }

    /**
     * 查询我的工作代办
     *
     * @return result
     */
    @GetMapping("/user/findMyWork")
    public TwOutputUtil findMyWork() {
        return TwOutputUtil.ok(service.findMyWork());
    }

 
    /**
     * 查询我的提醒
     *
     * @return result
     */
    @GetMapping("/user/findMyRemind")
    public TwOutputUtil findMyRemind() {
        return TwOutputUtil.ok(service.findMyRemind());
    }

    /**
     * 修改我的提醒
     *
     * @param remindType 提醒类型
     * @return result
     */
    @GetMapping("/user/updateMyRemind")
    public TwOutputUtil updateMyRemind(String remindType) {
        service.updateMyRemind(remindType);
        return TwOutputUtil.ok();
    }

    /**
     * 查询我的所有组织
     *
     * @return result
     */
    @GetMapping("/user/queryOrgList")
    public TwOutputUtil queryOrgList() {
        return TwOutputUtil.ok(service.queryOrgList());
    }

    /**
     * 查询我的所有下级
     *
     * @param orgId 组织id
     * @return result
     */
    @GetMapping("/user/queryLowList")
    public TwOutputUtil queryLowList(Long orgId) {
        return TwOutputUtil.ok(service.queryLowListByKey(orgId));
    }

    /**
     * 通过ticket获取用户数据
     * 接口作用：
     * 1、tw5.0跳转4.0，例如：5.0创建合同跳转至4.0
     * 2、tw4.0校验ticket
     *
     * @return result
     */
    @PostMapping("/user/queryUserByTicket")
    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        service.queryUserByTicket(request, response);
        // return TwOutputUtil.ok();
    }

}
